/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.handler;

import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.xstopho.resource_backpacks.client.model.BackpackModel;
import net.xstopho.resource_backpacks.client.renderer.ArmorStandBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.CreeperBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.PlayerBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.ZombieBackpackLayer;
import net.xstopho.resource_backpacks.network.BackpackNetwork;
import net.xstopho.resource_backpacks.network.payloads.OpenBackpackPayload;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

@Mod.EventBusSubscriber(modid="resource_backpacks", value={Dist.CLIENT})
public class ForgeClientHandler {
    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent.Post event) {
        if (KeyMappingRegistry.OPEN_BACKPACK.consumeClick()) {
            BackpackNetwork.INSTANCE.sendToServer(new OpenBackpackPayload());
        }
    }

    @SubscribeEvent
    public static void registerRenderLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BackpackModel.BACKPACK_LAYER, BackpackModel::createLayer);
    }

    @SubscribeEvent
    public static void registerKeyMapping(RegisterKeyMappingsEvent event) {
        event.register(KeyMappingRegistry.OPEN_BACKPACK);
        event.register(KeyMappingRegistry.SHOW_COMPACT_PREVIEW);
        event.register(KeyMappingRegistry.SHOW_INVENTORY_PREVIEW);
    }

    @SubscribeEvent
    public static void addRenderLayer(EntityRenderersEvent.AddLayers event) {
        event.getModelTypes().forEach(model -> {
            AvatarRenderer renderer = (AvatarRenderer)event.getPlayerRenderer(model);
            if (renderer != null) {
                renderer.addLayer((RenderLayer)new PlayerBackpackLayer((RenderLayerParent<AvatarRenderState, PlayerModel>)renderer, event.getContext().getModelSet()));
            }
        });
        BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            EntityRenderer entityRenderer = event.getEntityRenderer(entityType);
            if (entityRenderer instanceof CreeperRenderer) {
                CreeperRenderer creeper = (CreeperRenderer)entityRenderer;
                creeper.addLayer((RenderLayer)new CreeperBackpackLayer((RenderLayerParent<CreeperRenderState, CreeperModel>)creeper, event.getContext().getModelSet()));
            }
            if (entityRenderer instanceof ZombieRenderer) {
                ZombieRenderer zombie = (ZombieRenderer)entityRenderer;
                zombie.addLayer((RenderLayer)new ZombieBackpackLayer((RenderLayerParent<ZombieRenderState, ZombieModel<ZombieRenderState>>)zombie, event.getContext().getModelSet()));
            }
            if (entityRenderer instanceof ArmorStandRenderer) {
                ArmorStandRenderer armorStand = (ArmorStandRenderer)entityRenderer;
                armorStand.addLayer((RenderLayer)new ArmorStandBackpackLayer((RenderLayerParent<ArmorStandRenderState, ArmorStandArmorModel>)armorStand, event.getContext().getModelSet()));
            }
        });
    }
}

