/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.mixin.common;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.xstopho.resource_backpacks.backpack.BackpackItem;
import net.xstopho.resource_backpacks.backpack.component.BackpackContainerContents;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.mixin.accessor.ShapedRecipeAccessor;
import net.xstopho.resource_backpacks.registries.DataComponentRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapedRecipe.class})
public abstract class ShapedRecipeMixin {
    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"assemble(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"})
    private void onAssemble(CraftingInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = ((ShapedRecipeAccessor)((Object)this)).getResult().copy();
        Item item = result.getItem();
        if (item instanceof BackpackItem) {
            BackpackContainerContents container;
            BackpackItem backpackItem = (BackpackItem)item;
            ItemStack backpack = input.getItem(4);
            if (backpack.getItem() instanceof BackpackItem && (container = (BackpackContainerContents)backpack.get((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get())) != null) {
                if (backpackItem.getBackpackLevel().equals((Object)BackpackLevel.END) && !this.emptyContainer(container)) {
                    cir.setReturnValue((Object)new ItemStack((ItemLike)Items.AIR));
                } else {
                    result.set((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get(), (Object)container);
                    cir.setReturnValue((Object)result);
                }
            }
        }
    }

    @Unique
    private boolean emptyContainer(BackpackContainerContents container) {
        for (ItemStack stack : container.toList()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

