/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.registries;

import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.xstopho.resource_backpacks.backpack.BackpackBlock;
import net.xstopho.resource_backpacks.backpack.BackpackItem;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class BlockRegistry {
    private static final RegistryProvider<Block> BLOCKS = RegistryProvider.get((String)"resource_backpacks", (Registry)BuiltInRegistries.BLOCK);
    private static final RegistryProvider<Item> ITEMS = RegistryProvider.get((String)"resource_backpacks", (Registry)BuiltInRegistries.ITEM);
    public static final RegistryObject<Block> BACKPACK_LEATHER = BlockRegistry.registerBlock("backpack_leather", BackpackLevel.LEATHER);
    public static final RegistryObject<Block> BACKPACK_COPPER = BlockRegistry.registerBlock("backpack_copper", BackpackLevel.COPPER);
    public static final RegistryObject<Block> BACKPACK_GOLD = BlockRegistry.registerBlock("backpack_gold", BackpackLevel.GOLD);
    public static final RegistryObject<Block> BACKPACK_IRON = BlockRegistry.registerBlock("backpack_iron", BackpackLevel.IRON);
    public static final RegistryObject<Block> BACKPACK_DIAMOND = BlockRegistry.registerBlock("backpack_diamond", BackpackLevel.DIAMOND);
    public static final RegistryObject<Block> BACKPACK_NETHERITE = BlockRegistry.registerBlock("backpack_netherite", BackpackLevel.NETHERITE);
    public static final RegistryObject<Block> BACKPACK_END = BlockRegistry.registerBlock("backpack_end", BackpackLevel.END);

    private static RegistryObject<Block> registerBlock(String id, BackpackLevel level) {
        BlockBehaviour.Properties blockBehaviour = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).strength(0.5f).sound(SoundType.WOOL);
        blockBehaviour = level.equals((Object)BackpackLevel.NETHERITE) ? blockBehaviour.explosionResistance(1200.0f) : blockBehaviour;
        return BlockRegistry.registerBlock(id, properties -> new BackpackBlock((BlockBehaviour.Properties)properties, level), level, blockBehaviour);
    }

    private static RegistryObject<Block> registerBlock(String id, Function<BlockBehaviour.Properties, Block> function, BackpackLevel level, BlockBehaviour.Properties blockBehavior) {
        ResourceKey<Block> blockId = BlockRegistry.createBlockId(id);
        RegistryObject block = BLOCKS.register(id, () -> (Block)function.apply(blockBehavior.setId(blockId)));
        Item.Properties itemProperties = level == BackpackLevel.NETHERITE ? new Item.Properties().fireResistant() : new Item.Properties();
        BlockRegistry.registerItem(id, properties -> new BackpackItem((Block)block.get(), level, (Item.Properties)properties), itemProperties.useBlockDescriptionPrefix());
        return block;
    }

    private static void registerItem(String id, Function<Item.Properties, Item> function, Item.Properties properties) {
        ResourceKey<Item> itemId = BlockRegistry.createItemId(id);
        ITEMS.register(id, () -> (Item)function.apply(properties.setId(itemId).stacksTo(1)));
    }

    private static ResourceKey<Block> createBlockId(String id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"resource_backpacks", (String)id));
    }

    private static ResourceKey<Item> createItemId(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"resource_backpacks", (String)id));
    }

    public static void init() {
    }
}

