/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_10010;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10086;
import net.minecraft.class_304;
import net.minecraft.class_3883;
import net.minecraft.class_3886;
import net.minecraft.class_3887;
import net.minecraft.class_548;
import net.minecraft.class_5601;
import net.minecraft.class_562;
import net.minecraft.class_591;
import net.minecraft.class_623;
import net.minecraft.class_877;
import net.minecraft.class_887;
import net.minecraft.class_9998;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.backpack.tooltip.CompactClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.tooltip.InventoryClientTooltipComponent;
import net.xstopho.resource_backpacks.client.model.BackpackModel;
import net.xstopho.resource_backpacks.client.renderer.ArmorStandBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.CreeperBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.PlayerBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.ZombieBackpackLayer;
import net.xstopho.resource_backpacks.network.BackpackNetwork;
import net.xstopho.resource_backpacks.network.payloads.EnderChestResponsePayload;
import net.xstopho.resource_backpacks.network.payloads.OpenBackpackPayload;
import net.xstopho.resource_backpacks.network.payloads.SyncEntityBackpackPayload;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

public class ResourceBackpacksClient
implements ClientModInitializer {
    private final class_304 openBackpack = KeyBindingHelper.registerKeyBinding((class_304)KeyMappingRegistry.OPEN_BACKPACK);

    public void onInitializeClient() {
        BackpackConstants.clientInit();
        BackpackConstants.packInit();
        this.registerTooltipComponents();
        this.registerClientPayloads();
        this.registerKeyMapping();
        this.registerRendering();
    }

    private void registerClientPayloads() {
        ClientPlayNetworking.registerGlobalReceiver(EnderChestResponsePayload.TYPE, (payload, context) -> EnderChestResponsePayload.handle(payload));
        ClientPlayNetworking.registerGlobalReceiver(SyncEntityBackpackPayload.TYPE, (payload, context) -> SyncEntityBackpackPayload.handle(payload));
    }

    private void registerRendering() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)BackpackModel.BACKPACK_LAYER, BackpackModel::createLayer);
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, renderer, helper, context) -> {
            if (renderer instanceof class_1007) {
                class_1007 player = (class_1007)renderer;
                helper.register((class_3887)new PlayerBackpackLayer((class_3883<class_10055, class_591>)player, context.method_32170()));
            }
            if (renderer instanceof class_877) {
                class_877 armorStand = (class_877)renderer;
                helper.register((class_3887)new ArmorStandBackpackLayer((class_3883<class_9998, class_548>)armorStand, context.method_32170()));
            }
            if (renderer instanceof class_3886) {
                class_3886 zombie = (class_3886)renderer;
                helper.register((class_3887)new ZombieBackpackLayer((class_3883<class_10086, class_623<class_10086>>)zombie, context.method_32170()));
            }
            if (renderer instanceof class_887) {
                class_887 creeper = (class_887)renderer;
                helper.register((class_3887)new CreeperBackpackLayer((class_3883<class_10010, class_562>)creeper, context.method_32170()));
            }
        });
    }

    private void registerTooltipComponents() {
        TooltipComponentCallback.EVENT.register(component -> {
            if (component instanceof CompactClientTooltipComponent.CompactTooltipComponent) {
                CompactClientTooltipComponent.CompactTooltipComponent data = (CompactClientTooltipComponent.CompactTooltipComponent)component;
                return new CompactClientTooltipComponent(data);
            }
            if (component instanceof InventoryClientTooltipComponent.InventoryTooltipComponent) {
                InventoryClientTooltipComponent.InventoryTooltipComponent data = (InventoryClientTooltipComponent.InventoryTooltipComponent)component;
                return new InventoryClientTooltipComponent(data);
            }
            return null;
        });
    }

    private void registerKeyMapping() {
        KeyBindingHelper.registerKeyBinding((class_304)KeyMappingRegistry.SHOW_COMPACT_PREVIEW);
        KeyBindingHelper.registerKeyBinding((class_304)KeyMappingRegistry.SHOW_INVENTORY_PREVIEW);
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> {
            if (this.openBackpack.method_1436()) {
                BackpackNetwork.INSTANCE.sendToServer(new OpenBackpackPayload());
            }
        });
    }
}

