/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.client.screen;

import java.util.LinkedList;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.client.metadata.BackpackColorMetadata;
import net.xstopho.resource_backpacks.client.screen.BackpackMenu;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;
import net.xstopho.resourcelibrary.util.ResourcePackUtils;

public class BackpackMenuScreen
extends class_465<BackpackMenu> {
    private final class_2960 SLOT = this.texture("slot");
    private final class_2960 CORNER = this.texture("corner");
    private final class_2960 SIDE_VERTICAL = this.texture("side_vertical");
    private final class_2960 SIDE_HORIZONTAL = this.texture("side_horizontal");
    private final class_2960 INVENTORY_NORMAL = this.texture("inventory_normal");
    private final class_2960 INVENTORY_EXTENDED = this.texture("inventory_extended");
    private final int rows;
    private final int columns;

    public BackpackMenuScreen(BackpackMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.rows = menu.getBackpackLevel().getRows();
        this.columns = menu.getBackpackLevel().getColumns();
        this.field_2792 = this.getWidth();
        this.field_2779 = this.getHeight() + 107;
    }

    protected void method_2389(class_332 guiGraphics, float v, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderBackpackMenu(guiGraphics, x, y);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        LinkedList data = ResourcePackUtils.readAllMetaData(BackpackColorMetadata.TYPE);
        int titleColor = data.isEmpty() ? -12566464 : ((BackpackColorMetadata)data.getLast()).getColor();
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, titleColor, false);
    }

    private void renderBackpackMenu(class_332 guiGraphics, int xPos, int yPos) {
        this.renderCorner(guiGraphics, xPos, yPos, 0.0f, 0.0f);
        this.renderCorner(guiGraphics, xPos, yPos + this.getHeight(), 0.0f, 11.0f);
        this.renderCorner(guiGraphics, xPos + this.getWidth() - 11, yPos, 11.0f, 0.0f);
        this.renderCorner(guiGraphics, xPos + this.getWidth() - 11, yPos + this.getHeight(), 11.0f, 11.0f);
        this.renderHorizontalSide(guiGraphics, xPos + 11, yPos, 4.0f, 0.0f, this.getWidth() - 22, 18);
        this.renderHorizontalSide(guiGraphics, xPos + 11, yPos + this.getHeight() - 7, 4.0f, 4.0f, this.getWidth() - 22, 18);
        this.renderVerticalSide(guiGraphics, xPos, yPos + 11, 0.0f, 4.0f, 18, this.getHeight() - 11);
        this.renderVerticalSide(guiGraphics, xPos + this.getWidth() - 18, yPos + 11, 4.0f, 4.0f, 18, this.getHeight() - 11);
        this.renderSlots(guiGraphics, xPos + 7, yPos + 17, this.columns * 18, this.rows * 18);
        this.renderPlayerInventory(guiGraphics, xPos, yPos);
    }

    private void renderCorner(class_332 guiGraphics, int xPos, int yPos, float xOffset, float yOffset) {
        guiGraphics.method_25290(class_10799.field_56883, this.CORNER, xPos, yPos, xOffset, yOffset, 11, 11, 22, 22);
    }

    private void renderHorizontalSide(class_332 guiGraphics, int xPos, int yPos, float xOffset, float yOffset, int width, int height) {
        guiGraphics.method_25290(class_10799.field_56883, this.SIDE_HORIZONTAL, xPos, yPos, xOffset, yOffset, width, height, 22, 22);
    }

    private void renderVerticalSide(class_332 guiGraphics, int xPos, int yPos, float xOffset, float yOffset, int width, int height) {
        guiGraphics.method_25290(class_10799.field_56883, this.SIDE_VERTICAL, xPos, yPos, xOffset, yOffset, width, height, 22, 22);
    }

    private void renderSlots(class_332 guiGraphics, int xPos, int yPos, int width, int height) {
        guiGraphics.method_25290(class_10799.field_56883, this.SLOT, xPos, yPos, 0.0f, 0.0f, width, height, 18, 18);
    }

    private void renderPlayerInventory(class_332 guiGraphics, int xPos, int yPos) {
        class_2960 inventory = this.columns < 10 ? this.INVENTORY_NORMAL : this.INVENTORY_EXTENDED;
        guiGraphics.method_25290(class_10799.field_56883, inventory, xPos + (this.getWidth() - 175) / 2, yPos + this.getHeight() + 7, 0.0f, 0.0f, 176, 87, 176, 87);
    }

    private int getWidth() {
        return this.columns * 18 + 14;
    }

    private int getHeight() {
        return this.rows * 18 + 18;
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (KeyMappingRegistry.OPEN_BACKPACK.method_1417(keyEvent)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    private class_2960 texture(String texture) {
        return BackpackConstants.of(String.format("textures/gui/container/backpack/%s.png", texture));
    }
}

