/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.tooltip;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.xstopho.resource_backpacks.backpack.component.BackpackContainerContents;
import net.xstopho.resource_backpacks.backpack.tooltip.BaseClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;

public class CompactClientTooltipComponent
extends BaseClientTooltipComponent {
    private final List<BaseClientTooltipComponent.StackHolder> items;

    public CompactClientTooltipComponent(CompactTooltipComponent component) {
        List<ItemStack> itemList = component.content().toList();
        if (component.level.equals((Object)BackpackLevel.END)) {
            Player player = BackpackClientUtils.getPlayer();
            itemList = this.getEnderChestItems(player);
        }
        this.items = this.getCompactItemList(itemList);
    }

    @Override
    public void renderPreview(Font font, int x, int y, GuiGraphics guiGraphics) {
        int xOffset = 0;
        int yOffset = 0;
        for (BaseClientTooltipComponent.StackHolder holder : this.items) {
            this.renderDecoratedItem(font, holder.getStack(), holder.getCount(), x + xOffset, y + yOffset, guiGraphics);
            if ((xOffset += 18) != this.getWidth(font)) continue;
            xOffset = 0;
            yOffset += 18;
        }
    }

    public int getHeight(Font font) {
        if (!this.items.isEmpty()) {
            return (int)Math.ceil((double)this.items.size() / 10.0) * 18;
        }
        return 0;
    }

    public int getWidth(Font font) {
        return this.items.size() < 10 ? this.items.size() * 18 : 180;
    }

    private List<BaseClientTooltipComponent.StackHolder> getCompactItemList(List<ItemStack> items) {
        ArrayList<BaseClientTooltipComponent.StackHolder> holderList = new ArrayList<BaseClientTooltipComponent.StackHolder>();
        for (ItemStack stack : items) {
            boolean combined = false;
            if (stack.isEmpty()) continue;
            for (BaseClientTooltipComponent.StackHolder holder : holderList) {
                if (stack.getItem() != holder.getItem() || stack.isDamageableItem()) continue;
                combined = holder.combine(stack);
            }
            if (combined) continue;
            holderList.add(new BaseClientTooltipComponent.StackHolder(stack));
        }
        holderList.sort(Comparator.comparingInt(BaseClientTooltipComponent.StackHolder::getCount));
        return holderList.reversed();
    }

    public record CompactTooltipComponent(BackpackContainerContents content, BackpackLevel level) implements TooltipComponent
    {
    }
}

