/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.modifier;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.xstopho.resource_backpacks.backpack.api.BackpackHolder;
import net.xstopho.resource_backpacks.config.common.EntityConfig;
import net.xstopho.resource_backpacks.network.BackpackNetwork;
import net.xstopho.resource_backpacks.network.payloads.SyncEntityBackpackPayload;
import net.xstopho.resource_backpacks.registries.BlockRegistry;
import net.xstopho.resourcelibrary.registration.RegistryObject;

public class EntityModifier {
    public static void modifyEntities(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.getType() == EntityType.ZOMBIE) {
                EntityModifier.modify(livingEntity, () -> Float.valueOf(EntityConfig.zombieSpawnWithLeatherBackpack), BlockRegistry.BACKPACK_LEATHER);
                EntityModifier.modify(livingEntity, () -> Float.valueOf(EntityConfig.zombieSpawnWithCopperBackpack), BlockRegistry.BACKPACK_COPPER);
            }
            if (livingEntity.getType() == EntityType.CREEPER) {
                EntityModifier.modify(livingEntity, () -> Float.valueOf(EntityConfig.creeperSpawnWithLeatherBackpack), BlockRegistry.BACKPACK_LEATHER);
                EntityModifier.modify(livingEntity, () -> Float.valueOf(EntityConfig.creeperSpawnWithCopperBackpack), BlockRegistry.BACKPACK_COPPER);
            }
        }
    }

    private static void modify(LivingEntity livingEntity, Supplier<Float> chance, RegistryObject<Block> registryObject) {
        ItemStack backpack = ((Block)registryObject.get()).asItem().getDefaultInstance();
        Random random = new Random();
        float rndFloat = random.nextFloat();
        if (chance.get().floatValue() == 0.0f || EntityModifier.hasBackpack(livingEntity)) {
            return;
        }
        if (rndFloat <= chance.get().floatValue()) {
            ((BackpackHolder)livingEntity).setBackpack(backpack);
            if (!livingEntity.level().isClientSide()) {
                BackpackNetwork.INSTANCE.sendToClientsTrackingEntity(livingEntity, new SyncEntityBackpackPayload(livingEntity.getId(), backpack));
            }
        }
    }

    private static boolean hasBackpack(LivingEntity livingEntity) {
        return !((BackpackHolder)livingEntity).getBackpack().isEmpty();
    }
}

