/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.xstopho.resource_backpacks.backpack.BackpackBlock;
import net.xstopho.resource_backpacks.backpack.api.ImplementedInventory;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.screen.BackpackMenu;
import net.xstopho.resource_backpacks.registries.BlockEntityRegistry;
import org.jetbrains.annotations.NotNull;

public class BackpackBlockEntity
extends BaseContainerBlockEntity
implements ImplementedInventory {
    private NonNullList<ItemStack> items;
    private BackpackLevel backpackLevel;

    public BackpackBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.BACKPACK_ENTITY.get(), pos, blockState);
        this.backpackLevel = BackpackBlock.getLevelFromBlock(blockState.getBlock());
        this.items = NonNullList.withSize((int)this.backpackLevel.getSize(), (Object)ItemStack.EMPTY);
    }

    public BackpackBlockEntity(BlockPos pos, BlockState state, BackpackLevel backpackLevel) {
        this(pos, state);
        this.backpackLevel = backpackLevel;
        this.items = NonNullList.withSize((int)backpackLevel.getSize(), (Object)ItemStack.EMPTY);
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"component.resource_backpacks.screen.fallback");
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return switch (this.backpackLevel) {
            default -> throw new MatchException(null, null);
            case BackpackLevel.LEATHER -> BackpackMenu.leatherMenu(i, inventory, (Container)this, true);
            case BackpackLevel.COPPER -> BackpackMenu.copperMenu(i, inventory, (Container)this, true);
            case BackpackLevel.GOLD -> BackpackMenu.goldMenu(i, inventory, (Container)this, true);
            case BackpackLevel.IRON -> BackpackMenu.ironMenu(i, inventory, (Container)this, true);
            case BackpackLevel.DIAMOND -> BackpackMenu.diamondMenu(i, inventory, (Container)this, true);
            case BackpackLevel.NETHERITE -> BackpackMenu.netheriteMenu(i, inventory, (Container)this, true);
            case BackpackLevel.END -> BackpackMenu.endMenu(i, inventory, (Container)inventory.player.getEnderChestInventory(), true);
        };
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadFromTag(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (boolean)true, (HolderLookup.Provider)registries);
    }

    public void loadFromTag(CompoundTag tag, HolderLookup.Provider levelRegistry) {
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)levelRegistry);
    }
}

