/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.xstopho.resource_backpacks.backpack.tooltip.CompactClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.tooltip.InventoryClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.util.BackpackInventory;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.screen.BackpackMenu;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;
import net.xstopho.resource_backpacks.config.common.BackpackConfig;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

public class BackpackItem
extends BlockItem {
    private final BackpackLevel backpackLevel;

    public BackpackItem(Block block, BackpackLevel backpackLevel, Item.Properties properties) {
        super(block, properties.component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
        this.backpackLevel = backpackLevel;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide && BackpackConfig.openFromInventory) {
            player.openMenu(this.getMenuProvider(stack));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && (player.isCrouching() || !BackpackConfig.openFromInventory)) {
            super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    public MenuProvider getMenuProvider(ItemStack stack) {
        BackpackInventory backpackInventory = new BackpackInventory(stack, this.backpackLevel);
        return switch (this.backpackLevel) {
            default -> throw new MatchException(null, null);
            case BackpackLevel.LEATHER -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.leatherMenu(i, inventory, (Container)backpackInventory, false), this.getDescription());
            case BackpackLevel.COPPER -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.copperMenu(i, inventory, (Container)backpackInventory, false), this.getDescription());
            case BackpackLevel.GOLD -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.goldMenu(i, inventory, (Container)backpackInventory, false), this.getDescription());
            case BackpackLevel.IRON -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.ironMenu(i, inventory, (Container)backpackInventory, false), this.getDescription());
            case BackpackLevel.DIAMOND -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.diamondMenu(i, inventory, (Container)backpackInventory, false), this.getDescription());
            case BackpackLevel.NETHERITE -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.netheriteMenu(i, inventory, (Container)backpackInventory, false), this.getDescription());
            case BackpackLevel.END -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.endMenu(i, inventory, (Container)player.getEnderChestInventory(), false), this.getDescription());
        };
    }

    public BackpackLevel getBackpackLevel() {
        return this.backpackLevel;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ItemContainerContents content = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        Optional<TooltipComponent> tooltipComponent = Optional.empty();
        if (this.enableCompactPreview()) {
            tooltipComponent = Optional.of(new CompactClientTooltipComponent.CompactTooltipComponent(content, this.backpackLevel));
        } else if (this.enableInventoryPreview()) {
            tooltipComponent = Optional.of(new InventoryClientTooltipComponent.InventoryTooltipComponent(content, this.backpackLevel));
        }
        return tooltipComponent;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (!this.enableCompactPreview() && !this.enableInventoryPreview()) {
            if (!KeyMappingRegistry.SHOW_COMPACT_PREVIEW.isUnbound()) {
                tooltip.add((Component)KeyMappingRegistry.SHOW_COMPACT_PREVIEW.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)"tooltip.resource_backpacks.info.compact_preview").withStyle(ChatFormatting.WHITE)));
            }
            if (!KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.isUnbound()) {
                tooltip.add((Component)KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)"tooltip.resource_backpacks.info.inventory_preview").withStyle(ChatFormatting.WHITE)));
            }
        }
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    private boolean enableCompactPreview() {
        return BackpackClientUtils.hasKeyDown(KeyMappingRegistry.SHOW_COMPACT_PREVIEW);
    }

    private boolean enableInventoryPreview() {
        return BackpackClientUtils.hasKeyDown(KeyMappingRegistry.SHOW_INVENTORY_PREVIEW);
    }
}

