/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.api;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.xstopho.resource_backpacks.client.slot.BackpackSlot;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface BackpackHolder {
    public static final String tagId = "resource_backpacks$backpack";

    public ItemStack getBackpack();

    public void setBackpack(ItemStack var1);

    public static void restorePlayerBackpack(Player oldPlayer, Player newPlayer) {
        ItemStack itemStack = ((BackpackHolder)oldPlayer).getBackpack();
        for (Slot slot : newPlayer.inventoryMenu.slots) {
            if (!(slot instanceof BackpackSlot)) continue;
            slot.set(itemStack);
        }
    }

    default public void dropBackpack(Level level, BlockPos pos) {
        ItemStack itemStack = this.getBackpack();
        if (!itemStack.isEmpty() && !level.isClientSide()) {
            ItemEntity entity = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), itemStack);
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
        }
    }

    default public void readBackpackFromCompound(CompoundTag tag, HolderLookup.Provider registryAccess) {
        if (tag.contains(tagId)) {
            ItemStack backpack = ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)tag.getCompound(tagId)).orElse(ItemStack.EMPTY);
            this.setBackpack(backpack);
        }
    }

    default public void saveBackpackOnCompound(CompoundTag tag, HolderLookup.Provider registryAccess) {
        ItemStack itemStack = this.getBackpack();
        if (!itemStack.isEmpty()) {
            Tag backpack = itemStack.save(registryAccess);
            tag.put(tagId, backpack);
        }
    }
}

