/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.tooltip;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.xstopho.resource_backpacks.network.BackpackNetwork;
import net.xstopho.resource_backpacks.network.payloads.EnderChestRequestPayload;

public abstract class BaseClientTooltipComponent
implements ClientTooltipComponent {
    public abstract void renderPreview(Font var1, int var2, int var3, GuiGraphics var4);

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        this.renderPreview(font, x, y, guiGraphics);
    }

    protected List<ItemStack> getEnderChestItems(Player player) {
        BackpackNetwork.INSTANCE.sendToServer(new EnderChestRequestPayload());
        if (player != null) {
            PlayerEnderChestContainer container = player.getEnderChestInventory();
            return container.getItems();
        }
        return List.of();
    }

    public void renderDecoratedItem(Font font, ItemStack stack, int count, int x, int y, GuiGraphics guiGraphics) {
        if (!stack.isEmpty()) {
            guiGraphics.pose().pushPose();
            guiGraphics.renderItem(stack, x, y);
            this.renderItemBar(stack, x, y, guiGraphics);
            this.renderItemCount(font, count, x, y, guiGraphics);
            guiGraphics.pose().popPose();
        }
    }

    private void renderItemBar(ItemStack stack, int x, int y, GuiGraphics guiGraphics) {
        if (stack.isBarVisible()) {
            int xPos = x + 2;
            int yPos = y + 13;
            guiGraphics.fill(RenderType.gui(), xPos, yPos, xPos + 13, yPos + 2, 200, -16777216);
            guiGraphics.fill(RenderType.gui(), xPos, yPos, xPos + stack.getBarWidth(), yPos + 1, 200, stack.getBarColor() | 0xFF000000);
        }
    }

    private void renderItemCount(Font font, int count, int x, int y, GuiGraphics guiGraphics) {
        if (count != 1) {
            Component component = this.getReadableNumber(count);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.drawString(font, component, x + 17 - font.width((FormattedText)component), y + 9, -1, true);
            guiGraphics.pose().popPose();
        }
    }

    private Component getReadableNumber(int count) {
        return count > 1000 ? Component.literal((String)String.format("%.1fk", (double)count / 1000.0)) : Component.literal((String)String.valueOf(count));
    }

    public static final class StackHolder {
        private final ItemStack stack;
        private int count;

        public StackHolder(ItemStack stack) {
            this.stack = stack;
            this.count = stack.getCount();
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public Item getItem() {
            return this.stack.getItem();
        }

        public int getCount() {
            return this.count;
        }

        public boolean combine(ItemStack stack) {
            this.count += stack.getCount();
            return true;
        }
    }
}

