/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.tooltip;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.xstopho.resource_backpacks.backpack.tooltip.BaseClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;

public class InventoryClientTooltipComponent
extends BaseClientTooltipComponent {
    private final BackpackLevel level;
    private List<ItemStack> items;

    public InventoryClientTooltipComponent(InventoryTooltipComponent component) {
        this.level = component.level();
        this.items = component.content().stream().toList();
        if (this.level.equals((Object)BackpackLevel.END)) {
            Player player = BackpackClientUtils.getPlayer();
            this.items = this.getEnderChestItems(player);
        }
    }

    @Override
    public void renderPreview(Font font, int x, int y, GuiGraphics guiGraphics) {
        int xOffset = 0;
        int yOffset = 0;
        for (ItemStack stack : this.items) {
            this.renderDecoratedItem(font, stack, stack.getCount(), x + xOffset, y + yOffset, guiGraphics);
            if ((xOffset += 18) != this.getWidth(font)) continue;
            xOffset = 0;
            yOffset += 18;
        }
    }

    public int getHeight() {
        return this.level.getRows() * 18;
    }

    public int getWidth(Font font) {
        return this.level.getColumns() * 18;
    }

    public record InventoryTooltipComponent(ItemContainerContents content, BackpackLevel level) implements TooltipComponent
    {
    }
}

