/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.util;

import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.xstopho.resource_backpacks.backpack.api.ImplementedInventory;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;

public class BackpackInventory
implements ImplementedInventory {
    private final NonNullList<ItemStack> items;
    private final BackpackLevel backpackLevel;
    private final ItemStack stack;

    public BackpackInventory(ItemStack stack, BackpackLevel backpackLevel) {
        this.items = NonNullList.withSize((int)backpackLevel.getSize(), (Object)ItemStack.EMPTY);
        this.backpackLevel = backpackLevel;
        this.stack = stack;
        ItemContainerContents container = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (container != null) {
            container.copyInto(this.items);
        }
    }

    @Override
    public int getContainerSize() {
        return this.backpackLevel.getSize();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void setChanged() {
        this.stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
    }
}

