/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.util;

import java.util.function.Supplier;
import net.xstopho.resource_backpacks.config.common.BackpackConfig;

public enum BackpackLevel {
    LEATHER(() -> BackpackConfig.leatherRows, () -> BackpackConfig.leatherColumns, 22),
    COPPER(() -> BackpackConfig.copperRows, () -> BackpackConfig.copperColumns, 42),
    GOLD(() -> BackpackConfig.goldRows, () -> BackpackConfig.goldColumns, 64),
    IRON(() -> BackpackConfig.ironRows, () -> BackpackConfig.ironColumns, 108),
    DIAMOND(() -> BackpackConfig.diamondRows, () -> BackpackConfig.diamondColumns, 160),
    NETHERITE(() -> BackpackConfig.netheriteRows, () -> BackpackConfig.netheriteColumns, 250),
    END(() -> 3, () -> 9, 27);

    final Supplier<Integer> rows;
    final Supplier<Integer> columns;
    final int maxSize;

    private BackpackLevel(Supplier<Integer> rows, Supplier<Integer> columns, int maxSize) {
        this.rows = rows;
        this.columns = columns;
        this.maxSize = maxSize;
    }

    public int getRows() {
        return this.rows.get();
    }

    public int getColumns() {
        return this.columns.get();
    }

    public int getSize() {
        return this.getRows() * this.getColumns();
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

