/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.client.slot;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.backpack.BackpackItem;
import net.xstopho.resource_backpacks.backpack.api.BackpackHolder;
import net.xstopho.resource_backpacks.network.BackpackNetwork;
import net.xstopho.resource_backpacks.network.payloads.SyncCreativeSlotPayload;
import net.xstopho.resource_backpacks.network.payloads.SyncEntityBackpackPayload;
import org.jetbrains.annotations.Nullable;

public class BackpackSlot
extends Slot {
    private static final ResourceLocation BACKPACK_SPRITE = BackpackConstants.of("item/empty_slot_backpack");
    private final Player player;

    public BackpackSlot(Container container, Player player) {
        super(container, 0, 26, 62);
        this.player = player;
    }

    public void setChanged() {
        ((BackpackHolder)this.player).setBackpack(this.getItem());
        if (!this.player.level().isClientSide()) {
            BackpackNetwork.INSTANCE.sendToClientsTrackingEntity((LivingEntity)this.player, new SyncEntityBackpackPayload(this.player.getId(), this.getItem()));
        } else if (this.player.isCreative()) {
            BackpackNetwork.INSTANCE.sendToServer(new SyncCreativeSlotPayload(this.index, this.getItem()));
        }
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem() instanceof BackpackItem;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)BACKPACK_SPRITE);
    }
}

