/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface BackpackRenderer<T extends LivingEntity> {
    public void renderBackpackModel(PoseStack var1, MultiBufferSource var2, int var3, ItemStack var4);

    default public void renderOnHumanoid(PoseStack poseStack, MultiBufferSource buffer, T entity, int light, ItemStack backpack) {
        if (backpack.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(-0.25, 0.0, 0.125);
        if (entity.isCrouching()) {
            poseStack.translate(0.0, -0.0625, -0.015);
        }
        this.renderBackpackModel(poseStack, buffer, light, backpack);
        poseStack.popPose();
    }

    default public void renderOnCreeper(PoseStack poseStack, MultiBufferSource buffer, int light, ItemStack backpack) {
        if (backpack.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.translate(0.0f, 0.5f, 0.0f);
        this.renderBackpackModel(poseStack, buffer, light, backpack);
        poseStack.popPose();
    }

    default public void renderOnArmorStand(PoseStack poseStack, MultiBufferSource buffer, int light, ItemStack backpack) {
        if (backpack.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(0.0f, 1.225f, 0.14f);
        this.renderBackpackModel(poseStack, buffer, light, backpack);
        poseStack.popPose();
    }
}

