/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.mixin.common;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.xstopho.resource_backpacks.backpack.BackpackItem;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapedRecipe.class})
public abstract class ShapedRecipeMixin {
    @Shadow
    public abstract ItemStack getResultItem(HolderLookup.Provider var1);

    @Inject(method={"assemble"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(CraftingInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = this.getResultItem(registries).copy();
        Item item = result.getItem();
        if (item instanceof BackpackItem) {
            ItemContainerContents container;
            BackpackItem backpackItem = (BackpackItem)item;
            ItemStack backpack = input.getItem(4);
            if (backpack.getItem() instanceof BackpackItem && (container = (ItemContainerContents)backpack.get(DataComponents.CONTAINER)) != null) {
                if (backpackItem.getBackpackLevel().equals((Object)BackpackLevel.END) && !this.emptyContainer(container)) {
                    cir.setReturnValue((Object)new ItemStack((ItemLike)Items.AIR));
                } else {
                    result.set(DataComponents.CONTAINER, (Object)container);
                    cir.setReturnValue((Object)result);
                }
            }
        }
    }

    @Unique
    private boolean emptyContainer(ItemContainerContents container) {
        for (ItemStack stack : container.stream().toList()) {
            if (stack.getItem() == Items.AIR) continue;
            return false;
        }
        return true;
    }
}

