/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.network.payloads;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;
import net.xstopho.resource_backpacks.network.BackpackCodecs;
import org.jetbrains.annotations.Nullable;

public record EnderChestResponsePayload(@Nullable ListTag inventory) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnderChestResponsePayload> TYPE = BackpackConstants.type("ender_chest_response_payload");
    public static final StreamCodec<RegistryFriendlyByteBuf, EnderChestResponsePayload> CODEC = StreamCodec.composite(BackpackCodecs.ENDER_CHEST, EnderChestResponsePayload::inventory, EnderChestResponsePayload::new);

    public static EnderChestResponsePayload create(PlayerEnderChestContainer container, HolderLookup.Provider registry) {
        return new EnderChestResponsePayload(container.createTag(registry));
    }

    public static void handle(EnderChestResponsePayload payload) {
        if (payload.inventory() == null) {
            return;
        }
        Player player = BackpackClientUtils.getPlayer();
        if (player != null) {
            player.getEnderChestInventory().fromTag(payload.inventory(), (HolderLookup.Provider)player.registryAccess());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

