/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.xstopho.resource_backpacks.client.screen.BackpackMenuScreen;
import net.xstopho.resource_backpacks.config.client.ClientConfig;
import net.xstopho.resource_backpacks.config.common.BackpackConfig;
import net.xstopho.resource_backpacks.config.common.ChestLootConfig;
import net.xstopho.resource_backpacks.config.common.EntityConfig;
import net.xstopho.resource_backpacks.modifier.ChestLootModifier;
import net.xstopho.resource_backpacks.registries.BlockEntityRegistry;
import net.xstopho.resource_backpacks.registries.BlockRegistry;
import net.xstopho.resource_backpacks.registries.CreativeTabRegistry;
import net.xstopho.resource_backpacks.registries.DataComponentRegistry;
import net.xstopho.resource_backpacks.registries.MenuTypeRegistry;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourcelibrary.modifier.LootTableModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackpackConstants {
    public static final String MOD_ID = "resource_backpacks";
    public static final String MOD_NAME = "Resource Backpacks";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Resource Backpacks");
    private static final LootTableModifier modifier = LootTableModifier.getInstance();

    public static void commonInit() {
        ConfigRegistry.register(ClientConfig.class, (String)MOD_ID);
        ConfigRegistry.register(BackpackConfig.class, (String)MOD_ID);
        ConfigRegistry.register(ChestLootConfig.class, (String)MOD_ID);
        ConfigRegistry.register(EntityConfig.class, (String)MOD_ID);
        ChestLootModifier.initLootModifier(modifier);
        DataComponentRegistry.init();
        BlockRegistry.init();
        BlockEntityRegistry.init();
        MenuTypeRegistry.init();
        CreativeTabRegistry.init();
    }

    public static void clientInit() {
        MenuScreens.register((MenuType)((MenuType)MenuTypeRegistry.LEATHER_MENU.get()), BackpackMenuScreen::new);
        MenuScreens.register((MenuType)((MenuType)MenuTypeRegistry.COPPER_MENU.get()), BackpackMenuScreen::new);
        MenuScreens.register((MenuType)((MenuType)MenuTypeRegistry.GOLD_MENU.get()), BackpackMenuScreen::new);
        MenuScreens.register((MenuType)((MenuType)MenuTypeRegistry.IRON_MENU.get()), BackpackMenuScreen::new);
        MenuScreens.register((MenuType)((MenuType)MenuTypeRegistry.DIAMOND_MENU.get()), BackpackMenuScreen::new);
        MenuScreens.register((MenuType)((MenuType)MenuTypeRegistry.NETHERITE_MENU.get()), BackpackMenuScreen::new);
        MenuScreens.register((MenuType)((MenuType)MenuTypeRegistry.END_MENU.get()), BackpackMenuScreen::new);
    }

    public static ResourceLocation of(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }

    public static <T extends CustomPacketPayload> CustomPacketPayload.Type<T> type(String id) {
        return new CustomPacketPayload.Type(BackpackConstants.of(id));
    }
}

