/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack;

import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.xstopho.resource_backpacks.backpack.component.BackpackContainerContents;
import net.xstopho.resource_backpacks.backpack.tooltip.CompactClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.tooltip.InventoryClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.util.BackpackInventory;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.screen.BackpackMenu;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;
import net.xstopho.resource_backpacks.config.common.BackpackConfig;
import net.xstopho.resource_backpacks.registries.DataComponentRegistry;

public class BackpackItem
extends BlockItem {
    private final BackpackLevel backpackLevel;

    public BackpackItem(Block block, BackpackLevel backpackLevel, Item.Properties properties) {
        super(block, properties.component((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get(), (Object)BackpackContainerContents.EMPTY));
        this.backpackLevel = backpackLevel;
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide && BackpackConfig.openFromInventory) {
            player.openMenu(this.getMenuProvider(stack));
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && (player.isCrouching() || !BackpackConfig.openFromInventory)) {
            super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    public MenuProvider getMenuProvider(ItemStack stack) {
        BackpackInventory backpackInventory = new BackpackInventory(stack, this.backpackLevel);
        return switch (this.backpackLevel) {
            default -> throw new MatchException(null, null);
            case BackpackLevel.LEATHER -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.leatherMenu(i, inventory, (Container)backpackInventory, false), this.getName());
            case BackpackLevel.COPPER -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.copperMenu(i, inventory, (Container)backpackInventory, false), this.getName());
            case BackpackLevel.GOLD -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.goldMenu(i, inventory, (Container)backpackInventory, false), this.getName());
            case BackpackLevel.IRON -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.ironMenu(i, inventory, (Container)backpackInventory, false), this.getName());
            case BackpackLevel.DIAMOND -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.diamondMenu(i, inventory, (Container)backpackInventory, false), this.getName());
            case BackpackLevel.NETHERITE -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.netheriteMenu(i, inventory, (Container)backpackInventory, false), this.getName());
            case BackpackLevel.END -> new SimpleMenuProvider((i, inventory, player) -> BackpackMenu.endMenu(i, inventory, (Container)player.getEnderChestInventory(), false), this.getName());
        };
    }

    public BackpackLevel getBackpackLevel() {
        return this.backpackLevel;
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        BackpackContainerContents content = (BackpackContainerContents)stack.get((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get());
        Optional<TooltipComponent> tooltipComponent = Optional.empty();
        if (BackpackClientUtils.enableCompactPreview()) {
            tooltipComponent = Optional.of(new CompactClientTooltipComponent.CompactTooltipComponent(content, this.backpackLevel));
        } else if (BackpackClientUtils.enableInventoryPreview()) {
            tooltipComponent = Optional.of(new InventoryClientTooltipComponent.InventoryTooltipComponent(content, this.backpackLevel));
        }
        return tooltipComponent;
    }
}

