/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.util;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.xstopho.resource_backpacks.backpack.api.ImplementedInventory;
import net.xstopho.resource_backpacks.backpack.component.BackpackContainerContents;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.registries.DataComponentRegistry;

public class BackpackInventory
implements ImplementedInventory {
    private final NonNullList<ItemStack> items;
    private final BackpackLevel backpackLevel;
    private final ItemStack stack;

    public BackpackInventory(ItemStack stack, BackpackLevel backpackLevel) {
        BackpackContainerContents container;
        this.items = NonNullList.withSize((int)backpackLevel.getSize(), (Object)ItemStack.EMPTY);
        this.backpackLevel = backpackLevel;
        this.stack = stack;
        ItemContainerContents oldContainer = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (oldContainer != null) {
            stack.set((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get(), (Object)new BackpackContainerContents(oldContainer));
            stack.remove(DataComponents.CONTAINER);
        }
        if ((container = (BackpackContainerContents)stack.get((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get())) != null) {
            container.copyInto(this.items);
        }
    }

    @Override
    public int getContainerSize() {
        return this.backpackLevel.getSize();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void setChanged() {
        this.stack.set((DataComponentType)DataComponentRegistry.BACKPACK_CONTAINER.get(), (Object)new BackpackContainerContents((List<ItemStack>)this.items));
    }
}

