/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.handler;

import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.xstopho.resource_backpacks.BackpackConstants;
import net.xstopho.resource_backpacks.client.model.BackpackModel;
import net.xstopho.resource_backpacks.client.renderer.ArmorStandBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.CreeperBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.PlayerBackpackLayer;
import net.xstopho.resource_backpacks.client.renderer.ZombieBackpackLayer;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

@EventBusSubscriber(modid="resource_backpacks", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ModClientHandler {
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        BackpackConstants.clientInit();
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(KeyMappingRegistry.OPEN_BACKPACK);
        event.register(KeyMappingRegistry.SHOW_COMPACT_PREVIEW);
        event.register(KeyMappingRegistry.SHOW_INVENTORY_PREVIEW);
    }

    @SubscribeEvent
    public static void registerRenderLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BackpackModel.BACKPACK_LAYER, BackpackModel::createLayer);
    }

    @SubscribeEvent
    public static void addRenderLayer(EntityRenderersEvent.AddLayers event) {
        event.getSkins().forEach(model -> {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(model);
            if (renderer != null) {
                renderer.addLayer((RenderLayer)new PlayerBackpackLayer((RenderLayerParent<PlayerRenderState, PlayerModel>)renderer, event.getContext().getModelSet()));
            }
        });
        event.getEntityTypes().forEach(entityType -> {
            EntityRenderer entityRenderer = event.getRenderer(entityType);
            if (entityRenderer instanceof CreeperRenderer) {
                CreeperRenderer creeper = (CreeperRenderer)entityRenderer;
                creeper.addLayer((RenderLayer)new CreeperBackpackLayer((RenderLayerParent<CreeperRenderState, CreeperModel>)creeper, event.getContext().getModelSet()));
            }
            if (entityRenderer instanceof ZombieRenderer) {
                ZombieRenderer zombie = (ZombieRenderer)entityRenderer;
                zombie.addLayer((RenderLayer)new ZombieBackpackLayer((RenderLayerParent<ZombieRenderState, ZombieModel<ZombieRenderState>>)zombie, event.getContext().getModelSet()));
            }
            if (entityRenderer instanceof ArmorStandRenderer) {
                ArmorStandRenderer armorStand = (ArmorStandRenderer)entityRenderer;
                armorStand.addLayer((RenderLayer)new ArmorStandBackpackLayer((RenderLayerParent<ArmorStandRenderState, ArmorStandArmorModel>)armorStand, event.getContext().getModelSet()));
            }
        });
    }
}

