/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client;

import com.mojang.logging.LogUtils;
import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.api.client.CtmLoader;
import me.pepperbell.continuity.api.client.CtmLoaderRegistry;
import me.pepperbell.continuity.api.client.CtmProperties;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.config.ContinuityConfigScreen;
import me.pepperbell.continuity.client.processor.BaseCachingPredicates;
import me.pepperbell.continuity.client.processor.CompactCtmQuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.TopQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.SimpleOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.StandardOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.CtmSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.FixedSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.HorizontalSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.HorizontalVerticalSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RandomSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RepeatSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.VerticalHorizontalSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.VerticalSpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.properties.CompactConnectingCtmProperties;
import me.pepperbell.continuity.client.properties.ConnectingCtmProperties;
import me.pepperbell.continuity.client.properties.OrientedConnectingCtmProperties;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.properties.RandomCtmProperties;
import me.pepperbell.continuity.client.properties.RepeatCtmProperties;
import me.pepperbell.continuity.client.properties.TileAmountValidator;
import me.pepperbell.continuity.client.properties.overlay.BaseOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.OrientedConnectingOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.RandomOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.RepeatOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCtmProperties;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.Logger;

@Mod(value="continuity")
public class ContinuityClient {
    public static final String ID = "continuity";
    public static final String NAME = "Continuity";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ContinuityClient(IEventBus modEventBus, ModContainer modContainer) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        ProcessingDataKeys.init();
        CtmLoaderRegistry registry = CtmLoaderRegistry.get();
        CtmLoader<BaseCtmProperties> loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.AtLeast(47), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new CtmSpriteProvider.Factory()));
        registry.registerLoader("ctm", loader);
        registry.registerLoader("glass", loader);
        loader = ContinuityClient.createLoader(CompactConnectingCtmProperties::new, new TileAmountValidator.AtLeast(5), new CompactCtmQuadProcessor.Factory(), false);
        registry.registerLoader("ctm_compact", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalSpriteProvider.Factory()));
        registry.registerLoader("horizontal", loader);
        registry.registerLoader("bookshelf", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalSpriteProvider.Factory()));
        registry.registerLoader("vertical", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalVerticalSpriteProvider.Factory()));
        registry.registerLoader("horizontal+vertical", loader);
        registry.registerLoader("h+v", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalHorizontalSpriteProvider.Factory()));
        registry.registerLoader("vertical+horizontal", loader);
        registry.registerLoader("v+h", loader);
        loader = ContinuityClient.createLoader(ConnectingCtmProperties::new, new TileAmountValidator.Exactly(1), new TopQuadProcessor.Factory());
        registry.registerLoader("top", loader);
        loader = ContinuityClient.createLoader(RandomCtmProperties::new, new SimpleQuadProcessor.Factory<RandomCtmProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("random", loader);
        loader = ContinuityClient.createLoader(RepeatCtmProperties::new, new RepeatCtmProperties.Validator(), new SimpleQuadProcessor.Factory<RepeatCtmProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("repeat", loader);
        loader = ContinuityClient.createLoader(BaseCtmProperties::new, new TileAmountValidator.Exactly(1), new SimpleQuadProcessor.Factory<BaseCtmProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("fixed", loader);
        loader = ContinuityClient.createLoader(StandardOverlayCtmProperties::new, new TileAmountValidator.AtLeast(17), new StandardOverlayQuadProcessor.Factory());
        registry.registerLoader("overlay", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.AtLeast(47), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new CtmSpriteProvider.Factory()));
        registry.registerLoader("overlay_ctm", loader);
        loader = ContinuityClient.createLoader(RandomOverlayCtmProperties::new, new SimpleOverlayQuadProcessor.Factory<RandomCtmProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("overlay_random", loader);
        loader = ContinuityClient.createLoader(RepeatOverlayCtmProperties::new, new RepeatCtmProperties.Validator(), new SimpleOverlayQuadProcessor.Factory<RepeatCtmProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("overlay_repeat", loader);
        loader = ContinuityClient.createLoader(BaseOverlayCtmProperties::new, new TileAmountValidator.Exactly(1), new SimpleOverlayQuadProcessor.Factory<BaseCtmProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("overlay_fixed", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalSpriteProvider.Factory()));
        registry.registerLoader("overlay_horizontal", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalSpriteProvider.Factory()));
        registry.registerLoader("overlay_vertical", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalVerticalSpriteProvider.Factory()));
        registry.registerLoader("overlay_horizontal+vertical", loader);
        registry.registerLoader("overlay_h+v", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalHorizontalSpriteProvider.Factory()));
        registry.registerLoader("overlay_vertical+horizontal", loader);
        registry.registerLoader("overlay_v+h", loader);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, modListScreen) -> new ContinuityConfigScreen(modListScreen, ContinuityConfig.INSTANCE)));
    }

    private static <T extends CtmProperties> CtmLoader<T> createLoader(final CtmProperties.Factory<T> propertiesFactory, final QuadProcessor.Factory<T> processorFactory, final CachingPredicates.Factory<T> predicatesFactory) {
        return new CtmLoader<T>(){

            @Override
            public CtmProperties.Factory<T> getPropertiesFactory() {
                return propertiesFactory;
            }

            @Override
            public QuadProcessor.Factory<T> getProcessorFactory() {
                return processorFactory;
            }

            @Override
            public CachingPredicates.Factory<T> getPredicatesFactory() {
                return predicatesFactory;
            }
        };
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory, boolean isValidForMultipass) {
        return ContinuityClient.createLoader(ContinuityClient.wrapWithOptifineOnlyCheck(TileAmountValidator.wrapFactory(BaseCtmProperties.wrapFactory(propertiesFactory), validator)), processorFactory, new BaseCachingPredicates.Factory(isValidForMultipass));
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory) {
        return ContinuityClient.createLoader(propertiesFactory, validator, processorFactory, true);
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, QuadProcessor.Factory<T> processorFactory, boolean isValidForMultipass) {
        return ContinuityClient.createLoader(ContinuityClient.wrapWithOptifineOnlyCheck(BaseCtmProperties.wrapFactory(propertiesFactory)), processorFactory, new BaseCachingPredicates.Factory(isValidForMultipass));
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, QuadProcessor.Factory<T> processorFactory) {
        return ContinuityClient.createLoader(propertiesFactory, processorFactory, true);
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createCustomLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory, boolean isValidForMultipass) {
        return ContinuityClient.createLoader(TileAmountValidator.wrapFactory(BaseCtmProperties.wrapFactory(propertiesFactory), validator), processorFactory, new BaseCachingPredicates.Factory(isValidForMultipass));
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createCustomLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory) {
        return ContinuityClient.createCustomLoader(propertiesFactory, validator, processorFactory, true);
    }

    private static <T extends CtmProperties> CtmProperties.Factory<T> wrapWithOptifineOnlyCheck(CtmProperties.Factory<T> factory) {
        return (properties, resourceId, pack, packPriority, resourceManager, method) -> {
            if (PropertiesParsingHelper.parseOptifineOnly(properties, resourceId)) {
                return null;
            }
            return factory.createProperties(properties, resourceId, pack, packPriority, resourceManager, method);
        };
    }

    public static ResourceLocation asId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }
}

