/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.mixinterface.ModelLoaderExtension;
import me.pepperbell.continuity.client.resource.CustomBlockLayers;
import me.pepperbell.continuity.client.resource.ModelWrappingHandler;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyRegistryImpl;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(modid="continuity", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ContinuityClientModEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        ProcessingDataKeyRegistryImpl.INSTANCE.setFrozen();
    }

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        event.addPackFinders(ContinuityClient.asId("resourcepacks/default"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcePack.continuity.default.name"), PackSource.BUILT_IN, false, Pack.Position.TOP);
        event.addPackFinders(ContinuityClient.asId("resourcepacks/glass_pane_culling_fix"), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)"resourcePack.continuity.glass_pane_culling_fix.name"), PackSource.BUILT_IN, false, Pack.Position.TOP);
    }

    @SubscribeEvent
    public static void onRegisterResourceReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)RenderUtil.ReloadListener.INSTANCE);
        event.registerReloadListener((PreparableReloadListener)CustomBlockLayers.ReloadListener.INSTANCE);
    }

    @SubscribeEvent
    public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        ModelWrappingHandler wrappingHandler = ((ModelLoaderExtension)event.getModelBakery()).continuity$getModelWrappingHandler();
        if (wrappingHandler == null) {
            return;
        }
        Map bakedModels = event.getModels();
        ImmutableSet keys = ImmutableSet.copyOf(event.getModels().keySet());
        for (ModelResourceLocation modelResourceLocation : keys) {
            bakedModels.put(modelResourceLocation, wrappingHandler.wrap((BakedModel)bakedModels.get(modelResourceLocation), null, modelResourceLocation));
        }
    }
}

