/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.EnumSet;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.client.mixinterface.BlockAndTintGetterExtension;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BaseProcessingPredicate
implements ProcessingPredicate {
    @Nullable
    protected EnumSet<Direction> faces;
    @Nullable
    protected Predicate<Biome> biomePredicate;
    @Nullable
    protected IntPredicate heightPredicate;
    @Nullable
    protected Predicate<String> blockEntityNamePredicate;

    public BaseProcessingPredicate(@Nullable EnumSet<Direction> faces, @Nullable Predicate<Biome> biomePredicate, @Nullable IntPredicate heightPredicate, @Nullable Predicate<String> blockEntityNamePredicate) {
        this.faces = faces;
        this.biomePredicate = biomePredicate;
        this.heightPredicate = heightPredicate;
        this.blockEntityNamePredicate = blockEntityNamePredicate;
    }

    @Override
    public boolean shouldProcessQuad(QuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, ProcessingDataProvider dataProvider) {
        String blockEntityName;
        Biome biome;
        if (this.heightPredicate != null && !this.heightPredicate.test(pos.getY())) {
            return false;
        }
        if (this.faces != null) {
            Direction face = quad.lightFace();
            if (appearanceState.hasProperty((Property)BlockStateProperties.AXIS)) {
                Direction.Axis axis = (Direction.Axis)appearanceState.getValue((Property)BlockStateProperties.AXIS);
                if (axis == Direction.Axis.X) {
                    face = face.getClockWise(Direction.Axis.Z);
                } else if (axis == Direction.Axis.Z) {
                    face = face.getCounterClockWise(Direction.Axis.X);
                }
            }
            if (!this.faces.contains(face)) {
                return false;
            }
        }
        if (!(this.biomePredicate == null || (biome = dataProvider.getData(ProcessingDataKeys.BIOME_CACHE).get(blockView, pos)) != null && this.biomePredicate.test(biome))) {
            return false;
        }
        return this.blockEntityNamePredicate == null || (blockEntityName = dataProvider.getData(ProcessingDataKeys.BLOCK_ENTITY_NAME_CACHE).get(blockView, pos)) != null && this.blockEntityNamePredicate.test(blockEntityName);
    }

    public static BaseProcessingPredicate fromProperties(BaseCtmProperties properties) {
        return new BaseProcessingPredicate(properties.getFaces(), properties.getBiomePredicate(), properties.getHeightPredicate(), properties.getBlockEntityNamePredicate());
    }

    public static class BiomeCache {
        @Nullable
        protected Biome biome;
        protected boolean invalid = true;

        @Nullable
        public Biome get(BlockAndTintGetter blockView, BlockPos pos) {
            if (this.invalid) {
                this.biome = ((BlockAndTintGetterExtension)blockView).continuity$hasBiome() ? (Biome)((BlockAndTintGetterExtension)blockView).continuity$getBiome(pos).value() : null;
                this.invalid = false;
            }
            return this.biome;
        }

        public void reset() {
            this.invalid = true;
        }
    }

    public static class BlockEntityNameCache {
        @Nullable
        protected String blockEntityName;
        protected boolean invalid = true;

        @Nullable
        public String get(BlockAndTintGetter blockView, BlockPos pos) {
            if (this.invalid) {
                Nameable nameable;
                BlockEntity blockEntity = blockView.getBlockEntity(pos);
                this.blockEntityName = blockEntity instanceof Nameable ? ((nameable = (Nameable)blockEntity).hasCustomName() ? nameable.getCustomName().getString() : null) : null;
                this.invalid = false;
            }
            return this.blockEntityName;
        }

        public void reset() {
            this.invalid = true;
        }
    }
}

