/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties.overlay;

import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.properties.BasicConnectingCtmProperties;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class StandardOverlayCtmProperties
extends BasicConnectingCtmProperties
implements OverlayPropertiesSection.Provider {
    protected OverlayPropertiesSection overlaySection;
    @Nullable
    protected Set<ResourceLocation> connectTilesSet;
    @Nullable
    protected Predicate<BlockState> connectBlocksPredicate;

    public StandardOverlayCtmProperties(Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority, ResourceManager resourceManager, String method) {
        super(properties, resourceId, pack, packPriority, resourceManager, method);
        this.overlaySection = new OverlayPropertiesSection(properties, resourceId, this.packId);
    }

    @Override
    public void init() {
        super.init();
        this.overlaySection.init();
        this.parseConnectTiles();
        this.parseConnectBlocks();
    }

    @Override
    public OverlayPropertiesSection getOverlayPropertiesSection() {
        return this.overlaySection;
    }

    protected void parseConnectTiles() {
        this.connectTilesSet = PropertiesParsingHelper.parseMatchTiles(this.properties, "connectTiles", this.resourceId, this.packId, ResourceRedirectHandler.get(this.resourceManager));
    }

    protected void parseConnectBlocks() {
        this.connectBlocksPredicate = PropertiesParsingHelper.parseBlockStates(this.properties, "connectBlocks", this.resourceId, this.packId);
    }

    @Nullable
    public Set<ResourceLocation> getConnectTilesSet() {
        return this.connectTilesSet;
    }

    @Nullable
    public Predicate<BlockState> getConnectBlocksPredicate() {
        return this.connectBlocksPredicate;
    }
}

