/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class RenderUtil {
    private static final BlockColors BLOCK_COLORS = Minecraft.getInstance().getBlockColors();
    private static final ModelManager MODEL_MANAGER = Minecraft.getInstance().getModelManager();
    private static final ThreadLocal<MaterialFinder> MATERIAL_FINDER = ThreadLocal.withInitial(() -> RendererAccess.INSTANCE.getRenderer().materialFinder());
    private static SpriteFinder blockAtlasSpriteFinder;

    public static int getTintColor(@Nullable BlockState state, BlockAndTintGetter blockView, BlockPos pos, int tintIndex) {
        if (state == null || tintIndex == -1) {
            return -1;
        }
        return 0xFF000000 | BLOCK_COLORS.getColor(state, blockView, pos, tintIndex);
    }

    public static RenderMaterial findOverlayMaterial(BlendMode blendMode, @Nullable BlockState tintBlock) {
        MaterialFinder finder = RenderUtil.getMaterialFinder();
        finder.blendMode(blendMode);
        if (tintBlock != null) {
            finder.ambientOcclusion(TriState.of((boolean)RenderUtil.canHaveAO(tintBlock)));
        } else {
            finder.ambientOcclusion(TriState.TRUE);
        }
        return finder.find();
    }

    public static boolean canHaveAO(BlockState state) {
        return state.getLightEmission() == 0;
    }

    public static MaterialFinder getMaterialFinder() {
        return MATERIAL_FINDER.get().clear();
    }

    public static SpriteFinder getSpriteFinder() {
        return blockAtlasSpriteFinder;
    }

    public static class ReloadListener
    implements ResourceManagerReloadListener {
        public static final ReloadListener INSTANCE = new ReloadListener();

        public void onResourceManagerReload(ResourceManager manager) {
            blockAtlasSpriteFinder = SpriteFinder.get((TextureAtlas)MODEL_MANAGER.getAtlas(TextureAtlas.LOCATION_BLOCKS));
        }
    }
}

