/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.commands;

import com.cedarxuesong.serverlocalizer.mixins.mixinGUI.mixinChatLine;
import com.cedarxuesong.serverlocalizer.mixins.mixinGUI.mixinGuiNewChatAccess;
import com.cedarxuesong.serverlocalizer.utils.Lang;
import com.cedarxuesong.serverlocalizer.utils.ai.Message;
import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.ai.OpenAIClient;
import com.cedarxuesong.serverlocalizer.utils.ai.OpenAIResponse;
import com.cedarxuesong.serverlocalizer.utils.ai.Usage;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.cedarxuesong.serverlocalizer.utils.translation.ChatMessageCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ChatTranslateCommand
extends CommandBase {
    private static final String TAG = "ChatTranslateCommand";
    private static final String CHATTRANSLATION_API = "ChatTranslationApi";
    private static final ConcurrentHashMap<String, Boolean> translatingMessages = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, IChatComponent> messageComponentToReplaceMap = new ConcurrentHashMap();
    private static final ExecutorService translationExecutor = Executors.newFixedThreadPool(5);

    public String func_71517_b() {
        return "translate";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/translate <messageId>";
    }

    public void processSubCommand(ICommandSender sender, String[] args) {
        try {
            if (args.length < 1) {
                this.showUsage(sender);
                return;
            }
            if (!ModConfig.getInstance().isChatTranslationEnabled()) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(Lang.translate("command.serverlocalizer.translate.disabled")));
                return;
            }
            String messageId = args[0];
            IChatComponent originalMessage = ChatMessageCache.getInstance().getCachedMessage(messageId);
            if (originalMessage != null) {
                if (translatingMessages.putIfAbsent(messageId, true) != null) {
                    mylog.log(TAG, "\u8be5\u6d88\u606f\u5df2\u5728\u7ffb\u8bd1\u961f\u5217\u4e2d: " + messageId);
                    return;
                }
                if (ModConfig.getInstance().isChatStreamEnabled()) {
                    this.handleStreamTranslation(messageId, originalMessage);
                } else {
                    this.handleStandardTranslation(messageId, originalMessage);
                }
            } else {
                mylog.error(TAG, "\u672a\u627e\u5230ID\u5bf9\u5e94\u7684\u6d88\u606f: " + messageId, new Exception("\u6d88\u606fID\u65e0\u6548"));
            }
        }
        catch (Exception e) {
            mylog.error(TAG, "\u5904\u7406\u7ffb\u8bd1\u6d88\u606f\u547d\u4ee4\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        this.showUsage(sender);
    }

    private void showUsage(ICommandSender sender) {
        ChatComponentText usageMessage = new ChatComponentText(Lang.translate("command.serverlocalizer.translate.usage"));
        sender.func_145747_a((IChatComponent)usageMessage);
    }

    private OpenAIResponse translateTextWithUsage(String text) {
        ModConfig config = ModConfig.getInstance();
        String apiKey = config.getApiKey(CHATTRANSLATION_API);
        if (apiKey == null || apiKey.isEmpty()) {
            return new OpenAIResponse(null, Lang.translate("command.serverlocalizer.translate.api_key_empty"), 400);
        }
        try {
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(new Message("system", config.getSystemPrompt(CHATTRANSLATION_API)));
            messages.add(new Message("user", text));
            return OpenAIClient.sendRequestWithConfig(CHATTRANSLATION_API, messages);
        }
        catch (Exception e) {
            mylog.error(TAG, "\u8c03\u7528\u7ffb\u8bd1API\u65f6\u53d1\u751f\u9519\u8bef", e);
            return new OpenAIResponse(null, String.format(Lang.translate("command.serverlocalizer.translate.api_error"), e.getMessage()), 500);
        }
    }

    private String cleanTranslationOutput(String content) {
        Pattern thinkPattern = Pattern.compile("<think>.*?</think>", 32);
        Matcher thinkMatcher = thinkPattern.matcher(content);
        content = thinkMatcher.replaceAll("");
        content = content.replaceAll("\\[[TC]]", "");
        return content.trim();
    }

    private boolean replaceMessageInChatLines(GuiNewChat chatGUI, IChatComponent original, IChatComponent replacement) {
        try {
            mixinGuiNewChatAccess accessor = (mixinGuiNewChatAccess)chatGUI;
            List<ChatLine> chatLines = accessor.getChatLines();
            List<ChatLine> drawnChatLines = accessor.getDrawnChatLines();
            boolean replaced = false;
            replaced |= this.replaceInChatLineList(chatLines, original, replacement);
            return replaced |= this.replaceInChatLineList(drawnChatLines, original, replacement);
        }
        catch (Exception e) {
            mylog.error(TAG, "\u66ff\u6362\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceInChatLineList(List<ChatLine> chatLines, IChatComponent original, IChatComponent replacement) {
        boolean replaced = false;
        List<ChatLine> list = chatLines;
        synchronized (list) {
            for (ChatLine chatLine : chatLines) {
                try {
                    mixinChatLine accessor = (mixinChatLine)chatLine;
                    IChatComponent lineComponent = accessor.getLineString();
                    if (lineComponent == null || lineComponent != original) continue;
                    accessor.setLineString(replacement);
                    replaced = true;
                }
                catch (Exception e) {
                    mylog.error(TAG, "\u66ff\u6362ChatLine\u4e2d\u7684\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", e);
                }
            }
        }
        return replaced;
    }

    public int func_82362_a() {
        return 0;
    }

    public static void shutdown() {
        translationExecutor.shutdown();
    }

    private void refreshChatWithScroll(GuiNewChat chatGUI) {
        mixinGuiNewChatAccess accessor = (mixinGuiNewChatAccess)chatGUI;
        int scrollPos = accessor.getScrollPos();
        chatGUI.func_146245_b();
        accessor.setScrollPos(scrollPos);
    }

    private void handleStandardTranslation(String messageId, IChatComponent originalMessage) {
        String originalText = originalMessage.func_150254_d();
        Minecraft mc = Minecraft.func_71410_x();
        GuiNewChat chatGUI = mc.field_71456_v.func_146158_b();
        ChatComponentText loadingMessage = new ChatComponentText(Lang.translate("command.serverlocalizer.translate.translating"));
        loadingMessage.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
        messageComponentToReplaceMap.put(messageId, (IChatComponent)loadingMessage);
        try {
            if (this.replaceMessageInChatLines(chatGUI, originalMessage, (IChatComponent)loadingMessage)) {
                this.refreshChatWithScroll(chatGUI);
                mylog.log(TAG, "\u663e\u793a\u7ffb\u8bd1\u52a0\u8f7d\u4e2d: " + messageId);
                translationExecutor.submit(() -> {
                    try {
                        OpenAIResponse response = this.translateTextWithUsage(originalText);
                        String translatedText = Lang.translate("command.serverlocalizer.translate.failed");
                        Usage usage = null;
                        if (response.isSuccess()) {
                            translatedText = this.cleanTranslationOutput(response.extractMessageContent());
                            usage = response.getUsage();
                        } else {
                            translatedText = String.format(Lang.translate("command.serverlocalizer.translate.failed_with_error"), response.getError());
                        }
                        ChatComponentText translatedMessage = new ChatComponentText(translatedText);
                        translatedMessage.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                        if (usage != null) {
                            ChatComponentText hoverText = new ChatComponentText(usage.toString());
                            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)hoverText);
                            translatedMessage.func_150256_b().func_150209_a(hoverEvent);
                        }
                        ChatComponentText finalTranslatedMessage = translatedMessage;
                        mc.func_152344_a(() -> this.lambda$null$0(messageId, chatGUI, (IChatComponent)finalTranslatedMessage));
                    }
                    catch (Exception e) {
                        this.handleTranslationError(messageId, e.getMessage());
                    }
                });
            } else {
                translatingMessages.remove(messageId);
                mylog.error(TAG, "\u672a\u80fd\u627e\u5230\u8981\u7ffb\u8bd1\u7684\u6d88\u606f: " + messageId, null);
            }
        }
        catch (Exception e) {
            translatingMessages.remove(messageId);
            mylog.error(TAG, "\u66ff\u6362\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef: " + messageId, e);
        }
    }

    private void handleStreamTranslation(String messageId, IChatComponent originalMessage) {
        ChatComponentText connectingMessage;
        Minecraft mc = Minecraft.func_71410_x();
        GuiNewChat chatGUI = mc.field_71456_v.func_146158_b();
        if (this.replaceMessageInChatLines(chatGUI, originalMessage, (IChatComponent)(connectingMessage = new ChatComponentText(Lang.translate("command.serverlocalizer.translate.connecting"))))) {
            this.refreshChatWithScroll(chatGUI);
            messageComponentToReplaceMap.put(messageId, (IChatComponent)connectingMessage);
            StringBuilder fullText = new StringBuilder();
            boolean[] isThinking = new boolean[]{false};
            boolean[] hasReceivedContent = new boolean[]{false};
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(new Message("system", ModConfig.getInstance().getSystemPrompt(CHATTRANSLATION_API)));
            messages.add(new Message("user", originalMessage.func_150254_d()));
            OpenAIClient.sendStreamRequestWithConfig(CHATTRANSLATION_API, messages, chunk -> {
                fullText.append((String)chunk);
                String currentFullText = fullText.toString();
                IChatComponent oldComp = messageComponentToReplaceMap.get(messageId);
                if (oldComp == null) {
                    return;
                }
                if (currentFullText.contains("<think>") && !currentFullText.contains("</think>")) {
                    if (!isThinking[0]) {
                        isThinking[0] = true;
                    }
                    String thinkingText = String.format(Lang.translate("command.serverlocalizer.translate.thinking"), fullText.length());
                    ChatComponentText newComp = new ChatComponentText(thinkingText);
                    String thinkingContent = "";
                    int thinkStartIndex = currentFullText.indexOf("<think>");
                    if (thinkStartIndex != -1) {
                        thinkingContent = currentFullText.substring(thinkStartIndex + "<think>".length());
                    }
                    ChatComponentText hoverTextComponent = new ChatComponentText(thinkingContent);
                    HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)hoverTextComponent);
                    newComp.func_150256_b().func_150209_a(hoverEvent);
                    messageComponentToReplaceMap.put(messageId, (IChatComponent)newComp);
                    mc.func_152344_a(() -> this.lambda$null$2(chatGUI, oldComp, (IChatComponent)newComp));
                    return;
                }
                isThinking[0] = false;
                if (!hasReceivedContent[0]) {
                    hasReceivedContent[0] = true;
                }
                ChatComponentText newComp = new ChatComponentText(this.cleanTranslationOutput(currentFullText));
                newComp.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                messageComponentToReplaceMap.put(messageId, (IChatComponent)newComp);
                mc.func_152344_a(() -> this.lambda$null$3(chatGUI, oldComp, (IChatComponent)newComp));
            }, usage -> mc.func_152344_a(() -> {
                IChatComponent finalComponent = messageComponentToReplaceMap.get(messageId);
                if (finalComponent != null && usage != null) {
                    ChatComponentText hoverText = new ChatComponentText("\u00a7ePromptTokens: " + usage.getPromptTokens() + "\n\u00a7eTotalTokens: " + usage.getTotalTokens() + "\n\u00a7eCompletionTokens: " + usage.getCompletionTokens());
                    HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)hoverText);
                    finalComponent.func_150256_b().func_150209_a(hoverEvent);
                    this.refreshChatWithScroll(chatGUI);
                }
                translatingMessages.remove(messageId);
                messageComponentToReplaceMap.remove(messageId);
                mylog.log(TAG, "\u6d41\u5f0f\u7ffb\u8bd1\u5b8c\u6210: " + messageId);
            }), arg_0 -> this.lambda$handleStreamTranslation$7(hasReceivedContent, messageId, (IChatComponent)connectingMessage, arg_0));
        } else {
            translatingMessages.remove(messageId);
            mylog.error(TAG, "\u672a\u80fd\u627e\u5230\u8981\u7ffb\u8bd1\u7684\u6d88\u606f (stream): " + messageId, null);
        }
    }

    private void handleTranslationError(String messageId, String errorMessageStr, IChatComponent componentToReplace) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            if (componentToReplace != null) {
                ChatComponentText errorMessage = new ChatComponentText(String.format(Lang.translate("command.serverlocalizer.translate.failed_with_error"), errorMessageStr));
                if (this.replaceMessageInChatLines(Minecraft.func_71410_x().field_71456_v.func_146158_b(), componentToReplace, (IChatComponent)errorMessage)) {
                    this.refreshChatWithScroll(Minecraft.func_71410_x().field_71456_v.func_146158_b());
                }
            } else {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(String.format(Lang.translate("command.serverlocalizer.translate.failed_with_id"), messageId, errorMessageStr)));
            }
            translatingMessages.remove(messageId);
            messageComponentToReplaceMap.remove(messageId);
        });
    }

    private void handleTranslationError(String messageId, String errorMessageStr) {
        this.handleTranslationError(messageId, errorMessageStr, messageComponentToReplaceMap.get(messageId));
    }

    private /* synthetic */ void lambda$handleStreamTranslation$7(boolean[] hasReceivedContent, String messageId, IChatComponent connectingMessage, String error) {
        IChatComponent componentToReplace = hasReceivedContent[0] ? messageComponentToReplaceMap.get(messageId) : connectingMessage;
        this.handleTranslationError(messageId, error, componentToReplace);
    }

    private /* synthetic */ void lambda$null$3(GuiNewChat chatGUI, IChatComponent oldComp, IChatComponent newComp) {
        if (this.replaceMessageInChatLines(chatGUI, oldComp, newComp)) {
            this.refreshChatWithScroll(chatGUI);
        }
    }

    private /* synthetic */ void lambda$null$2(GuiNewChat chatGUI, IChatComponent oldComp, IChatComponent newComp) {
        if (this.replaceMessageInChatLines(chatGUI, oldComp, newComp)) {
            this.refreshChatWithScroll(chatGUI);
        }
    }

    private /* synthetic */ void lambda$null$0(String messageId, GuiNewChat chatGUI, IChatComponent finalTranslatedMessage) {
        IChatComponent currentLoadingMessage = messageComponentToReplaceMap.get(messageId);
        if (currentLoadingMessage != null) {
            if (this.replaceMessageInChatLines(chatGUI, currentLoadingMessage, finalTranslatedMessage)) {
                this.refreshChatWithScroll(chatGUI);
                mylog.log(TAG, "\u7ffb\u8bd1\u5b8c\u6210: " + messageId);
            } else {
                mylog.error(TAG, "\u66f4\u65b0\u7ffb\u8bd1\u6d88\u606f\u5931\u8d25: " + messageId, null);
            }
        }
        translatingMessages.remove(messageId);
        messageComponentToReplaceMap.remove(messageId);
    }
}

