/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.commands;

import com.cedarxuesong.serverlocalizer.utils.Lang;
import com.cedarxuesong.serverlocalizer.utils.commands.ChatTranslateCommand;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.util.Arrays;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ServerLocalizerCommand
extends CommandBase {
    private static final String TAG = "ServerLocalizerCommand";
    public static boolean shouldOpenConfigGui = false;
    private final SubCommandHandler translateHandler = new TranslateCommandHandler();

    public String func_71517_b() {
        return "serverlocalizer";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/serverlocalizer <translate|config|apiconfig> [args...]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.showUsage(sender);
            return;
        }
        String subCommand = args[0];
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "translate": {
                this.translateHandler.handleCommand(sender, subArgs);
                break;
            }
            case "config": {
                this.openConfigGui();
                break;
            }
            default: {
                this.showUsage(sender);
            }
        }
    }

    private void openConfigGui() {
        mylog.log(TAG, "\u63a5\u6536\u5230\u6253\u5f00GUI\u7684\u6307\u4ee4\uff0c\u8bbe\u7f6e\u6807\u5fd7\u4f4d...");
        shouldOpenConfigGui = true;
    }

    private void showUsage(ICommandSender sender) {
        ChatComponentText usageMessage = new ChatComponentText(Lang.translate("command.serverlocalizer.usage"));
        sender.func_145747_a((IChatComponent)usageMessage);
    }

    public int func_82362_a() {
        return 0;
    }

    private static class TranslateCommandHandler
    implements SubCommandHandler {
        private final ChatTranslateCommand command = new ChatTranslateCommand();

        private TranslateCommandHandler() {
        }

        @Override
        public void handleCommand(ICommandSender sender, String[] args) {
            this.command.processSubCommand(sender, args);
        }
    }

    public static interface SubCommandHandler {
        public void handleCommand(ICommandSender var1, String[] var2);
    }
}

