/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui;

import com.cedarxuesong.serverlocalizer.utils.gui.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class ModernButton
extends GuiButton {
    private float hoverAnimation = 0.0f;
    private long lastFrameTime = System.currentTimeMillis();
    private int idleColor;
    private int hoverColor;

    public ModernButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, -13223617, -11907757);
    }

    public ModernButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, int idleColor, int hoverColor) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
        this.idleColor = idleColor;
        this.hoverColor = hoverColor;
    }

    public void setColors(int idleColor, int hoverColor) {
        this.idleColor = idleColor;
        this.hoverColor = hoverColor;
    }

    private int interpolateColor(int color1, int color2, float ratio) {
        if (ratio <= 0.01f) {
            return color1;
        }
        if (ratio >= 0.99f) {
            return color2;
        }
        float r1 = color1 >> 16 & 0xFF;
        float g1 = color1 >> 8 & 0xFF;
        float b1 = color1 & 0xFF;
        float a1 = color1 >> 24 & 0xFF;
        float r2 = color2 >> 16 & 0xFF;
        float g2 = color2 >> 8 & 0xFF;
        float b2 = color2 & 0xFF;
        float a2 = color2 >> 24 & 0xFF;
        int r = (int)(r1 + (r2 - r1) * ratio);
        int g = (int)(g1 + (g2 - g1) * ratio);
        int b = (int)(b1 + (b2 - b1) * ratio);
        int a = (int)(a1 + (a2 - a1) * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this.lastFrameTime;
            this.lastFrameTime = currentTime;
            if (deltaTime > 50L) {
                deltaTime = 50L;
            }
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            float targetAnimation = this.field_146123_n && this.field_146124_l ? 1.0f : 0.0f;
            double k = 0.04;
            float amountToMove = (float)(1.0 - Math.exp(-k * (double)deltaTime));
            this.hoverAnimation = Math.abs(targetAnimation - this.hoverAnimation) > 0.01f ? (this.hoverAnimation += (targetAnimation - this.hoverAnimation) * amountToMove) : targetAnimation;
            int backgroundColor = this.interpolateColor(this.idleColor, this.hoverColor, this.hoverAnimation);
            if (!this.field_146124_l) {
                backgroundColor = -14013135;
            }
            GuiUtils.drawRoundedRect(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 5.0f, backgroundColor);
            int textColor = -2039584;
            if (this.packedFGColour != 0) {
                textColor = this.packedFGColour;
            } else if (!this.field_146124_l) {
                textColor = -6250336;
            }
            this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, textColor);
        }
    }
}

