/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui.panel;

import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.gui.ConfigGui;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;

public abstract class BasePanel {
    protected Minecraft mc;
    protected GuiScreen parent;
    protected FontRenderer fontRendererObj;
    protected ModConfig modConfig;
    public final List<GuiButton> buttons = new ArrayList<GuiButton>();
    public final List<GuiTextField> textFields = new ArrayList<GuiTextField>();

    public BasePanel(GuiScreen parent) {
        this.mc = Minecraft.func_71410_x();
        this.parent = parent;
        this.fontRendererObj = this.mc.field_71466_p;
        this.modConfig = ModConfig.getInstance();
    }

    public abstract void initGui(int var1);

    public abstract void drawPanel(int var1, int var2, float var3, int var4, int var5);

    public abstract void addTooltips(int var1, int var2, int var3);

    public abstract int getContentHeight();

    public abstract void saveConfig();

    public abstract void resetConfig();

    public abstract void actionPerformed(GuiButton var1) throws IOException;

    public void keyTyped(char typedChar, int keyCode) throws IOException {
        for (GuiTextField textField : this.textFields) {
            if (!textField.func_146206_l()) continue;
            textField.func_146201_a(typedChar, keyCode);
        }
    }

    public void mouseClicked(int mouseX, int localMouseY, int mouseButton) throws IOException {
        for (GuiTextField textField : this.textFields) {
            textField.func_146192_a(mouseX, localMouseY, mouseButton);
        }
    }

    protected void drawHoveringText(List<String> textLines, int x, int y) {
        if (this.parent instanceof ConfigGui) {
            ((ConfigGui)this.parent).drawPublicHoveringText(textLines, x, y);
        }
    }

    protected boolean isMouseOver(GuiButton button, int mouseX, int localMouseY) {
        return button.field_146125_m && mouseX >= button.field_146128_h && localMouseY >= button.field_146129_i && mouseX < button.field_146128_h + button.field_146120_f && localMouseY < button.field_146129_i + button.field_146121_g;
    }

    protected boolean isMouseOver(GuiTextField field, int mouseX, int localMouseY) {
        return field.func_146176_q() && mouseX >= field.field_146209_f && localMouseY >= field.field_146210_g && mouseX < field.field_146209_f + field.field_146218_h && localMouseY < field.field_146210_g + field.field_146219_i;
    }

    protected void drawString(String text, int x, int y) {
        this.fontRendererObj.func_78276_b(text, x, y, -7433577);
    }
}

