/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui.panel;

import com.cedarxuesong.serverlocalizer.utils.Lang;
import com.cedarxuesong.serverlocalizer.utils.gui.ModernButton;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.BasePanel;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;

public class ChatTranslationPanel
extends BasePanel {
    private static final String TAG = "ChatTranslationPanel";
    private static final String API_NAME = "ChatTranslationApi";
    private ModernButton chatTranslationToggle;
    private ModernButton streamToggle;
    private GuiTextField chatBaseUrlField;
    private GuiTextField chatApiKeyField;
    private GuiTextField chatModelField;
    private GuiTextField chatTemperatureField;
    private GuiTextField chatSystemPromptField;
    private int maxLabelWidth = 0;

    public ChatTranslationPanel(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initGui(int panelWidth) {
        String[] apiLabels;
        this.buttons.clear();
        this.textFields.clear();
        int padding = 15;
        int contentWidth = panelWidth - padding * 2;
        this.maxLabelWidth = 0;
        for (String labelKey : apiLabels = new String[]{"gui.serverlocalizer.api.base_url", "gui.serverlocalizer.api.api_key", "gui.serverlocalizer.api.model", "gui.serverlocalizer.api.temperature", "gui.serverlocalizer.api.system_prompt"}) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, this.fontRendererObj.func_78256_a(Lang.translate(labelKey)));
        }
        int labelControlSpacing = 8;
        int fieldWidth = contentWidth - this.maxLabelWidth - labelControlSpacing;
        this.chatTranslationToggle = new ModernButton(203, 0, 0, 0, 20, "");
        this.streamToggle = new ModernButton(204, 0, 0, 0, 20, "");
        this.chatBaseUrlField = new GuiTextField(11, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatBaseUrlField.func_146203_f(Short.MAX_VALUE);
        this.chatApiKeyField = new GuiTextField(5, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatApiKeyField.func_146203_f(Short.MAX_VALUE);
        this.chatModelField = new GuiTextField(6, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatModelField.func_146203_f(Short.MAX_VALUE);
        this.chatTemperatureField = new GuiTextField(7, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatTemperatureField.func_146203_f(Short.MAX_VALUE);
        this.chatSystemPromptField = new GuiTextField(9, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatSystemPromptField.func_146203_f(Short.MAX_VALUE);
        this.buttons.add(this.chatTranslationToggle);
        this.buttons.add(this.streamToggle);
        this.textFields.add(this.chatBaseUrlField);
        this.textFields.add(this.chatApiKeyField);
        this.textFields.add(this.chatModelField);
        this.textFields.add(this.chatTemperatureField);
        this.textFields.add(this.chatSystemPromptField);
        this.resetConfig();
    }

    @Override
    public void drawPanel(int mouseX, int localMouseY, float partialTicks, int panelX, int panelY) {
        int padding = 15;
        int contentX = panelX + padding;
        int y = panelY + padding;
        int labelControlSpacing = 8;
        int controlX = contentX + this.maxLabelWidth + labelControlSpacing;
        this.chatTranslationToggle.field_146128_h = contentX;
        this.chatTranslationToggle.field_146129_i = y;
        this.drawString(Lang.translate("gui.serverlocalizer.api.base_url"), contentX, (y += 35) + 6);
        this.chatBaseUrlField.field_146209_f = controlX;
        this.chatBaseUrlField.field_146210_g = y;
        this.chatBaseUrlField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.api_key"), contentX, (y += 25) + 6);
        this.chatApiKeyField.field_146209_f = controlX;
        this.chatApiKeyField.field_146210_g = y;
        this.chatApiKeyField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.model"), contentX, (y += 25) + 6);
        this.chatModelField.field_146209_f = controlX;
        this.chatModelField.field_146210_g = y;
        this.chatModelField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.temperature"), contentX, (y += 25) + 6);
        this.chatTemperatureField.field_146209_f = controlX;
        this.chatTemperatureField.field_146210_g = y;
        this.chatTemperatureField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.system_prompt"), contentX, (y += 25) + 6);
        this.chatSystemPromptField.field_146209_f = controlX;
        this.chatSystemPromptField.field_146210_g = y;
        this.chatSystemPromptField.func_146194_f();
        this.streamToggle.field_146128_h = contentX;
        this.streamToggle.field_146129_i = y += 35;
    }

    @Override
    public void addTooltips(int mouseX, int mouseY, int localMouseY) {
        if (this.isMouseOver(this.chatTranslationToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.chat.tooltip.enable").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.streamToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.chat.tooltip.enable_stream").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatBaseUrlField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.base_url").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatApiKeyField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.api_key").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatModelField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.model").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatTemperatureField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.temperature").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatSystemPromptField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.system_prompt").split("\n")), mouseX, mouseY);
        }
    }

    @Override
    public int getContentHeight() {
        return 300;
    }

    @Override
    public void saveConfig() {
        this.modConfig.setBaseUrl(API_NAME, this.chatBaseUrlField.func_146179_b());
        this.modConfig.setApiKey(API_NAME, this.chatApiKeyField.func_146179_b());
        this.modConfig.setModel(API_NAME, this.chatModelField.func_146179_b());
        try {
            this.modConfig.setTemperature(API_NAME, Double.parseDouble(this.chatTemperatureField.func_146179_b()));
        }
        catch (NumberFormatException e) {
            mylog.error(TAG, "Invalid temperature value for chat translation: " + this.chatTemperatureField.func_146179_b());
        }
        this.modConfig.setSystemPrompt(API_NAME, this.chatSystemPromptField.func_146179_b());
    }

    @Override
    public void resetConfig() {
        this.chatBaseUrlField.func_146180_a(this.modConfig.getBaseUrl(API_NAME));
        this.chatApiKeyField.func_146180_a(this.modConfig.getApiKey(API_NAME));
        this.chatModelField.func_146180_a(this.modConfig.getModel(API_NAME));
        this.chatTemperatureField.func_146180_a(String.valueOf(this.modConfig.getTemperature(API_NAME)));
        this.chatSystemPromptField.func_146180_a(this.modConfig.getSystemPrompt(API_NAME));
        this.updateButtonLabels();
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 203: {
                boolean chatEnabled = !this.modConfig.isChatTranslationEnabled();
                this.modConfig.setChatTranslationEnabled(chatEnabled);
                break;
            }
            case 204: {
                boolean streamEnabled = !this.modConfig.isChatStreamEnabled();
                this.modConfig.setChatStreamEnabled(streamEnabled);
            }
        }
        this.updateButtonLabels();
    }

    private void updateButtonLabels() {
        int IDLE_ON = -10983950;
        int HOVER_ON = -12102972;
        int IDLE_OFF = -13223617;
        int HOVER_OFF = -11907757;
        int TEXT_COLOR = -1;
        boolean chatEnabled = this.modConfig.isChatTranslationEnabled();
        this.chatTranslationToggle.field_146126_j = Lang.translate("gui.serverlocalizer.chat.enable") + (chatEnabled ? "\u00a7a" + Lang.translate("options.on") : "\u00a7c" + Lang.translate("options.off"));
        this.chatTranslationToggle.field_146120_f = this.fontRendererObj.func_78256_a(this.chatTranslationToggle.field_146126_j) + 20;
        this.chatTranslationToggle.setColors(chatEnabled ? -10983950 : -13223617, chatEnabled ? -12102972 : -11907757);
        this.chatTranslationToggle.packedFGColour = -1;
        boolean streamEnabled = this.modConfig.isChatStreamEnabled();
        this.streamToggle.field_146126_j = Lang.translate("gui.serverlocalizer.chat.enable_stream") + (streamEnabled ? "\u00a7a" + Lang.translate("options.on") : "\u00a7c" + Lang.translate("options.off"));
        this.streamToggle.field_146120_f = this.fontRendererObj.func_78256_a(this.streamToggle.field_146126_j) + 20;
        this.streamToggle.setColors(streamEnabled ? -10983950 : -13223617, streamEnabled ? -12102972 : -11907757);
        this.streamToggle.packedFGColour = -1;
        this.streamToggle.field_146124_l = chatEnabled;
    }
}

