/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui.panel;

import com.cedarxuesong.serverlocalizer.utils.Lang;
import com.cedarxuesong.serverlocalizer.utils.gui.ModernButton;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.BasePanel;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;

public class ItemTranslationPanel
extends BasePanel {
    private static final String TAG = "ItemTranslationPanel";
    private static final String API_NAME = "ItemTranslationApi";
    private ModernButton itemTranslationToggle;
    private GuiTextField itemBaseUrlField;
    private GuiTextField itemApiKeyField;
    private GuiTextField itemModelField;
    private GuiTextField itemTemperatureField;
    private GuiTextField itemSystemPromptField;
    private ModernButton itemNameToggle;
    private ModernButton itemLoreToggle;
    private int maxLabelWidth = 0;

    public ItemTranslationPanel(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initGui(int panelWidth) {
        String[] apiLabels;
        this.buttons.clear();
        this.textFields.clear();
        int padding = 15;
        int contentWidth = panelWidth - padding * 2;
        this.maxLabelWidth = 0;
        for (String labelKey : apiLabels = new String[]{"gui.serverlocalizer.api.base_url", "gui.serverlocalizer.api.api_key", "gui.serverlocalizer.api.model", "gui.serverlocalizer.api.temperature", "gui.serverlocalizer.api.system_prompt"}) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, this.fontRendererObj.func_78256_a(Lang.translate(labelKey)));
        }
        int labelControlSpacing = 8;
        int fieldWidth = contentWidth - this.maxLabelWidth - labelControlSpacing;
        this.itemTranslationToggle = new ModernButton(200, 0, 0, 0, 20, "");
        this.itemNameToggle = new ModernButton(201, 0, 0, 0, 20, "");
        this.itemLoreToggle = new ModernButton(202, 0, 0, 0, 20, "");
        this.itemBaseUrlField = new GuiTextField(10, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemBaseUrlField.func_146203_f(Short.MAX_VALUE);
        this.itemApiKeyField = new GuiTextField(1, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemApiKeyField.func_146203_f(Short.MAX_VALUE);
        this.itemModelField = new GuiTextField(2, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemModelField.func_146203_f(Short.MAX_VALUE);
        this.itemTemperatureField = new GuiTextField(3, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemTemperatureField.func_146203_f(Short.MAX_VALUE);
        this.itemSystemPromptField = new GuiTextField(8, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemSystemPromptField.func_146203_f(Short.MAX_VALUE);
        this.buttons.add(this.itemTranslationToggle);
        this.buttons.add(this.itemNameToggle);
        this.buttons.add(this.itemLoreToggle);
        this.textFields.add(this.itemBaseUrlField);
        this.textFields.add(this.itemApiKeyField);
        this.textFields.add(this.itemModelField);
        this.textFields.add(this.itemTemperatureField);
        this.textFields.add(this.itemSystemPromptField);
        this.resetConfig();
    }

    @Override
    public void drawPanel(int mouseX, int localMouseY, float partialTicks, int panelX, int panelY) {
        int padding = 15;
        int contentX = panelX + padding;
        int y = panelY + padding;
        int labelControlSpacing = 8;
        int controlX = contentX + this.maxLabelWidth + labelControlSpacing;
        int toggleButtonSpacing = 10;
        this.itemTranslationToggle.field_146128_h = contentX;
        this.itemTranslationToggle.field_146129_i = y;
        this.drawString(Lang.translate("gui.serverlocalizer.api.base_url"), contentX, (y += 35) + 6);
        this.itemBaseUrlField.field_146209_f = controlX;
        this.itemBaseUrlField.field_146210_g = y;
        this.itemBaseUrlField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.api_key"), contentX, (y += 25) + 6);
        this.itemApiKeyField.field_146209_f = controlX;
        this.itemApiKeyField.field_146210_g = y;
        this.itemApiKeyField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.model"), contentX, (y += 25) + 6);
        this.itemModelField.field_146209_f = controlX;
        this.itemModelField.field_146210_g = y;
        this.itemModelField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.temperature"), contentX, (y += 25) + 6);
        this.itemTemperatureField.field_146209_f = controlX;
        this.itemTemperatureField.field_146210_g = y;
        this.itemTemperatureField.func_146194_f();
        this.drawString(Lang.translate("gui.serverlocalizer.api.system_prompt"), contentX, (y += 25) + 6);
        this.itemSystemPromptField.field_146209_f = controlX;
        this.itemSystemPromptField.field_146210_g = y;
        this.itemSystemPromptField.func_146194_f();
        this.itemNameToggle.field_146128_h = contentX;
        this.itemNameToggle.field_146129_i = y += 35;
        this.itemLoreToggle.field_146128_h = this.itemNameToggle.field_146128_h + this.itemNameToggle.field_146120_f + toggleButtonSpacing;
        this.itemLoreToggle.field_146129_i = y;
        long accumulatedTokens = this.modConfig.getAccumulatedTokens(API_NAME);
        String tokenUsageText = Lang.translate("gui.serverlocalizer.item.token_usage") + " " + accumulatedTokens;
        this.drawString(tokenUsageText, contentX, y += 35);
    }

    @Override
    public void addTooltips(int mouseX, int mouseY, int localMouseY) {
        if (this.isMouseOver(this.itemTranslationToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.item.tooltip.enable").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemBaseUrlField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.base_url").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemApiKeyField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.api_key").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemModelField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.model").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemTemperatureField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.temperature").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemSystemPromptField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.api.tooltip.system_prompt").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemNameToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.item.tooltip.enable_name").split("\n")), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemLoreToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList(Lang.translate("gui.serverlocalizer.item.tooltip.enable_lore").split("\n")), mouseX, mouseY);
        }
    }

    @Override
    public int getContentHeight() {
        return 340;
    }

    @Override
    public void saveConfig() {
        this.modConfig.setBaseUrl(API_NAME, this.itemBaseUrlField.func_146179_b());
        this.modConfig.setApiKey(API_NAME, this.itemApiKeyField.func_146179_b());
        this.modConfig.setModel(API_NAME, this.itemModelField.func_146179_b());
        try {
            this.modConfig.setTemperature(API_NAME, Double.parseDouble(this.itemTemperatureField.func_146179_b()));
        }
        catch (NumberFormatException e) {
            mylog.error(TAG, "Invalid temperature value for item translation: " + this.itemTemperatureField.func_146179_b());
        }
        this.modConfig.setSystemPrompt(API_NAME, this.itemSystemPromptField.func_146179_b());
    }

    @Override
    public void resetConfig() {
        this.itemBaseUrlField.func_146180_a(this.modConfig.getBaseUrl(API_NAME));
        this.itemApiKeyField.func_146180_a(this.modConfig.getApiKey(API_NAME));
        this.itemModelField.func_146180_a(this.modConfig.getModel(API_NAME));
        this.itemTemperatureField.func_146180_a(String.valueOf(this.modConfig.getTemperature(API_NAME)));
        this.itemSystemPromptField.func_146180_a(this.modConfig.getSystemPrompt(API_NAME));
        this.updateButtonLabels();
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 200: {
                boolean itemEnabled = !this.modConfig.isItemTranslationEnabled();
                this.modConfig.setItemTranslationEnabled(itemEnabled);
                break;
            }
            case 201: {
                boolean nameEnabled = !this.modConfig.isItemNameTranslationEnabled();
                this.modConfig.setItemNameTranslationEnabled(nameEnabled);
                break;
            }
            case 202: {
                boolean loreEnabled = !this.modConfig.isItemLoreTranslationEnabled();
                this.modConfig.setItemLoreTranslationEnabled(loreEnabled);
            }
        }
        this.updateButtonLabels();
    }

    private void updateButtonLabels() {
        int IDLE_ON = -10983950;
        int HOVER_ON = -12102972;
        int IDLE_OFF = -13223617;
        int HOVER_OFF = -11907757;
        int TEXT_COLOR = -1;
        boolean itemEnabled = this.modConfig.isItemTranslationEnabled();
        this.itemTranslationToggle.field_146126_j = Lang.translate("gui.serverlocalizer.item.enable") + (itemEnabled ? "\u00a7a" + Lang.translate("options.on") : "\u00a7c" + Lang.translate("options.off"));
        this.itemTranslationToggle.field_146120_f = this.fontRendererObj.func_78256_a(this.itemTranslationToggle.field_146126_j) + 20;
        this.itemTranslationToggle.setColors(itemEnabled ? -10983950 : -13223617, itemEnabled ? -12102972 : -11907757);
        this.itemTranslationToggle.packedFGColour = -1;
        boolean nameEnabled = this.modConfig.isItemNameTranslationEnabled();
        this.itemNameToggle.field_146126_j = Lang.translate("gui.serverlocalizer.item.enable_name") + (nameEnabled ? "\u00a7a" + Lang.translate("options.on") : "\u00a7c" + Lang.translate("options.off"));
        this.itemNameToggle.field_146120_f = this.fontRendererObj.func_78256_a(this.itemNameToggle.field_146126_j) + 20;
        this.itemNameToggle.setColors(nameEnabled ? -10983950 : -13223617, nameEnabled ? -12102972 : -11907757);
        this.itemNameToggle.packedFGColour = -1;
        this.itemNameToggle.field_146124_l = itemEnabled;
        boolean loreEnabled = this.modConfig.isItemLoreTranslationEnabled();
        this.itemLoreToggle.field_146126_j = Lang.translate("gui.serverlocalizer.item.enable_lore") + (loreEnabled ? "\u00a7a" + Lang.translate("options.on") : "\u00a7c" + Lang.translate("options.off"));
        this.itemLoreToggle.field_146120_f = this.fontRendererObj.func_78256_a(this.itemLoreToggle.field_146126_j) + 20;
        this.itemLoreToggle.setColors(loreEnabled ? -10983950 : -13223617, loreEnabled ? -12102972 : -11907757);
        this.itemLoreToggle.packedFGColour = -1;
        this.itemLoreToggle.field_146124_l = itemEnabled;
    }
}

