/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui.panel;

import com.cedarxuesong.serverlocalizer.utils.Lang;
import com.cedarxuesong.serverlocalizer.utils.gui.GuiUtils;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.BasePanel;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;

public class ProjectInfoPanel
extends BasePanel {
    private static final String TAG = "ProjectInfoPanel";
    private static final int LINK_COLOR = -10969610;
    private static final int LINK_HOVER_COLOR = -8145417;
    private final List<Rectangle> linkBounds = new ArrayList<Rectangle>();
    private final List<String> linkUrls = new ArrayList<String>();

    public ProjectInfoPanel(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initGui(int panelWidth) {
    }

    @Override
    public void drawPanel(int mouseX, int localMouseY, float partialTicks, int panelX, int panelY) {
        this.linkBounds.clear();
        this.linkUrls.clear();
        int padding = 15;
        int contentX = panelX + padding;
        int y = panelY + padding;
        int lineHeight = this.fontRendererObj.field_78288_b + 3;
        int sectionSpacing = 15;
        int contentWidth = this.mc.field_71462_r.field_146294_l - (panelX + padding * 2) - 100;
        String title = Lang.translate("gui.serverlocalizer.project.title");
        this.fontRendererObj.func_78276_b(title, contentX, y, -415707);
        String versionString = "v0.4.5-beta";
        this.fontRendererObj.func_78276_b(versionString, contentX + this.fontRendererObj.func_78256_a(title) + 5, y, -7433577);
        this.fontRendererObj.func_78279_b(Lang.translate("gui.serverlocalizer.project.description"), contentX, y += lineHeight, contentWidth, -1);
        GuiUtils.drawHorizontalLine(contentX, contentX + contentWidth, y += lineHeight * 3, 0x50FFFFFF);
        y += sectionSpacing;
        y = this.drawSectionHeader(Lang.translate("gui.serverlocalizer.project.section.features"), contentX, y, lineHeight);
        y = this.drawBulletPoint(Lang.translate("gui.serverlocalizer.project.feature.item_translation"), contentX, y, lineHeight, contentWidth);
        y = this.drawBulletPoint(Lang.translate("gui.serverlocalizer.project.feature.chat_translation"), contentX, y, lineHeight, contentWidth);
        y = this.drawBulletPoint(Lang.translate("gui.serverlocalizer.project.feature.config_gui"), contentX, y, lineHeight, contentWidth);
        y = this.drawBulletPoint(Lang.translate("gui.serverlocalizer.project.feature.openai_compatible"), contentX, y, lineHeight, contentWidth);
        y += sectionSpacing;
        y = this.drawSectionHeader(Lang.translate("gui.serverlocalizer.project.section.contact"), contentX, y, lineHeight);
        this.drawLink(Lang.translate("gui.serverlocalizer.project.link.github"), Lang.translate("gui.serverlocalizer.project.link.github_text"), "https://github.com/CedarXuesong/ServerLocalizer", contentX, y, mouseX, localMouseY);
        this.drawLink(Lang.translate("gui.serverlocalizer.project.link.issues"), Lang.translate("gui.serverlocalizer.project.link.issues_text"), "https://github.com/CedarXuesong/ServerLocalizer/issues", contentX, y += lineHeight, mouseX, localMouseY);
        this.drawLink(Lang.translate("gui.serverlocalizer.project.link.bilibili"), Lang.translate("gui.serverlocalizer.project.link.bilibili_text"), "https://space.bilibili.com/473773611", contentX, y += lineHeight, mouseX, localMouseY);
        y += sectionSpacing;
        y = this.drawSectionHeader(Lang.translate("gui.serverlocalizer.project.section.contribute"), contentX, y, lineHeight);
        this.fontRendererObj.func_78279_b(Lang.translate("gui.serverlocalizer.project.contribute.text"), contentX, y, contentWidth, -1);
    }

    private int drawSectionHeader(String text, int x, int y, int lineHeight) {
        this.fontRendererObj.func_78276_b(EnumChatFormatting.YELLOW + text, x, y, -415707);
        return y + lineHeight + 2;
    }

    private int drawBulletPoint(String text, int x, int y, int lineHeight, int wrapWidth) {
        this.fontRendererObj.func_78276_b("\u2022", x, y, -415707);
        this.fontRendererObj.func_78279_b(text, x + 10, y, wrapWidth - 10, -1);
        int lines = this.fontRendererObj.func_78271_c(text, wrapWidth - 10).size();
        return y + lineHeight * lines;
    }

    private void drawLink(String label, String linkText, String url, int x, int y, int mouseX, int localMouseY) {
        this.fontRendererObj.func_78276_b(label, x, y, -1);
        int linkX = x + this.fontRendererObj.func_78256_a(label);
        int linkWidth = this.fontRendererObj.func_78256_a(linkText);
        boolean isHovered = mouseX >= linkX && mouseX < linkX + linkWidth && localMouseY >= y && localMouseY < y + this.fontRendererObj.field_78288_b;
        this.fontRendererObj.func_78276_b(linkText, linkX, y, isHovered ? -8145417 : -10969610);
        if (isHovered) {
            GuiUtils.drawHorizontalLine(linkX, linkX + linkWidth, y + this.fontRendererObj.field_78288_b, -8145417);
        }
        this.linkBounds.add(new Rectangle(linkX, y, linkWidth, this.fontRendererObj.field_78288_b));
        this.linkUrls.add(url);
    }

    private void openUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            mylog.error(TAG, "Failed to open URL: " + url, e);
        }
    }

    @Override
    public void addTooltips(int mouseX, int mouseY, int localMouseY) {
        for (int i = 0; i < this.linkBounds.size(); ++i) {
            if (!this.linkBounds.get(i).contains(mouseX, localMouseY)) continue;
            this.drawHoveringText(Collections.singletonList(EnumChatFormatting.GRAY + Lang.translate("gui.serverlocalizer.project.tooltip.click_to_open") + this.linkUrls.get(i)), mouseX, mouseY);
            return;
        }
    }

    @Override
    public int getContentHeight() {
        return 280;
    }

    @Override
    public void saveConfig() {
    }

    @Override
    public void resetConfig() {
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
    }

    @Override
    public void mouseClicked(int mouseX, int localMouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, localMouseY, mouseButton);
        if (mouseButton == 0) {
            for (int i = 0; i < this.linkBounds.size(); ++i) {
                if (!this.linkBounds.get(i).contains(mouseX, localMouseY)) continue;
                this.openUrl(this.linkUrls.get(i));
                return;
            }
        }
    }
}

