/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.mylog;

import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.translation.ModuleTranslationManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DebugWindow {
    private static JFrame frame;
    private static JTextArea textArea;
    private static final SimpleDateFormat dateFormat;
    private static boolean isInitialized;
    private static boolean isWindowVisible;
    private static final Object LOCK;
    private static final int MAX_LINES = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Object object = LOCK;
        synchronized (object) {
            if (isInitialized && isWindowVisible) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    if (frame == null || !isWindowVisible) {
                        frame = new JFrame("\u8c03\u8bd5\u4fe1\u606f");
                        frame.setDefaultCloseOperation(2);
                        frame.setSize(1080, 1080);
                        textArea = new JTextArea();
                        textArea.setEditable(false);
                        textArea.setFont(new Font("Monospaced", 0, 12));
                        JScrollPane scrollPane = new JScrollPane(textArea);
                        frame.add(scrollPane);
                        JPanel bottomPanel = DebugWindow.getJPanel();
                        frame.add((Component)bottomPanel, "South");
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        frame.setLocation(screenSize.width / 2 - frame.getWidth() / 2, screenSize.height / 2 - frame.getHeight() / 2);
                        frame.addWindowListener(new WindowAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void windowClosing(WindowEvent windowEvent) {
                                Object object = LOCK;
                                synchronized (object) {
                                    isWindowVisible = false;
                                }
                            }
                        });
                        String initMessage = String.format("%s [%s] [%s]: %s%n", dateFormat.format(new Date()), LogLevel.INFO.name(), "DebugWindow", "\u8c03\u8bd5\u7a97\u53e3\u5df2\u521d\u59cb\u5316");
                        textArea.append(initMessage);
                        frame.setVisible(true);
                        isWindowVisible = true;
                        isInitialized = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private static JPanel getJPanel() {
        JPanel bottomPanel = new JPanel();
        JButton clearButton = new JButton("\u6e05\u9664\u65e5\u5fd7");
        clearButton.addActionListener(e -> DebugWindow.clearLog());
        bottomPanel.add(clearButton);
        JButton saveButton = new JButton("\u4fdd\u5b58\u7ffb\u8bd1");
        saveButton.addActionListener(e -> DebugWindow.saveTranslations());
        bottomPanel.add(saveButton);
        JButton loadButton = new JButton("\u52a0\u8f7d\u7ffb\u8bd1");
        loadButton.addActionListener(e -> DebugWindow.loadTranslations());
        bottomPanel.add(loadButton);
        JButton statusButton = new JButton("\u66f4\u591a");
        statusButton.addActionListener(e -> DebugWindow.showTranslationStatus());
        bottomPanel.add(statusButton);
        return bottomPanel;
    }

    private static void saveTranslations() {
        try {
            LogLevel level;
            String message;
            ModuleTranslationManager manager = ModuleTranslationManager.getInstance();
            boolean translationResult = manager.saveAllTranslations();
            boolean apiConfigResult = ModConfig.getInstance().saveConfig();
            if (translationResult && apiConfigResult) {
                message = "\u6240\u6709\u7ffb\u8bd1\u6587\u4ef6\u548cAPI\u914d\u7f6e\u5df2\u6210\u529f\u4fdd\u5b58";
                level = LogLevel.INFO;
            } else if (!translationResult && !apiConfigResult) {
                message = "\u7ffb\u8bd1\u6587\u4ef6\u548cAPI\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25";
                level = LogLevel.ERROR;
            } else if (!translationResult) {
                message = "\u7ffb\u8bd1\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff0cAPI\u914d\u7f6e\u5df2\u6210\u529f\u4fdd\u5b58";
                level = LogLevel.WARN;
            } else {
                message = "\u7ffb\u8bd1\u6587\u4ef6\u5df2\u6210\u529f\u4fdd\u5b58\uff0cAPI\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25";
                level = LogLevel.WARN;
            }
            DebugWindow.addLog("DebugWindow", message, level);
        }
        catch (Exception e) {
            DebugWindow.addLog("DebugWindow", "\u4fdd\u5b58\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage(), LogLevel.ERROR);
            e.printStackTrace();
        }
    }

    private static void loadTranslations() {
        try {
            LogLevel level;
            String message;
            ModuleTranslationManager manager = ModuleTranslationManager.getInstance();
            boolean translationResult = manager.reloadAllTranslations();
            ModConfig modConfig = ModConfig.getInstance();
            boolean apiConfigResult = modConfig.initialize();
            if (translationResult && apiConfigResult) {
                message = "\u6240\u6709\u7ffb\u8bd1\u6587\u4ef6\u548cAPI\u914d\u7f6e\u5df2\u6210\u529f\u52a0\u8f7d";
                level = LogLevel.INFO;
            } else if (!translationResult && !apiConfigResult) {
                message = "\u7ffb\u8bd1\u6587\u4ef6\u548cAPI\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25";
                level = LogLevel.ERROR;
            } else if (!translationResult) {
                message = "\u7ffb\u8bd1\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25\uff0cAPI\u914d\u7f6e\u5df2\u6210\u529f\u52a0\u8f7d";
                level = LogLevel.WARN;
            } else {
                message = "\u7ffb\u8bd1\u6587\u4ef6\u5df2\u6210\u529f\u52a0\u8f7d\uff0cAPI\u914d\u7f6e\u52a0\u8f7d\u5931\u8d25";
                level = LogLevel.WARN;
            }
            DebugWindow.addLog("DebugWindow", message, level);
        }
        catch (Exception e) {
            DebugWindow.addLog("DebugWindow", "\u52a0\u8f7d\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage(), LogLevel.ERROR);
            e.printStackTrace();
        }
    }

    private static void showTranslationStatus() {
        try {
            ModuleTranslationManager manager = ModuleTranslationManager.getInstance();
            boolean isInitialized = manager.isInitialized();
            boolean hasUnsavedChanges = manager.hasUnsavedChanges();
            ModConfig modConfig = ModConfig.getInstance();
            String chatApiUrl = modConfig.getBaseUrl("ChatTranslationApi");
            String itemApiUrl = modConfig.getBaseUrl("ItemTranslationApi");
            StringBuilder status = new StringBuilder();
            status.append("\u7ba1\u7406\u5668\u72b6\u6001:\n");
            status.append("- \u7248\u672c: ").append("0.4.5-beta").append("\n");
            status.append("- \u521d\u59cb\u5316: ").append(isInitialized ? "true" : "false").append("\n");
            status.append("- \u672a\u4fdd\u5b58\u66f4\u6539: ").append(hasUnsavedChanges ? "true" : "false").append("\n\n");
            status.append("\u6a21\u5757\u72b6\u6001:\n");
            status.append("- \u7269\u54c1\u7ffb\u8bd1: ").append(manager.getItemTranslator().getTranslationCount()).append(" \u6761\n\n");
            status.append("API\u914d\u7f6e\u72b6\u6001:\n");
            status.append("- \u804a\u5929\u7ffb\u8bd1API: ").append(chatApiUrl.isEmpty() ? "\u672a\u914d\u7f6e" : chatApiUrl).append("\n");
            status.append("- \u7269\u54c1\u7ffb\u8bd1API: ").append(itemApiUrl.isEmpty() ? "\u672a\u914d\u7f6e" : itemApiUrl).append("\n\n");
            status.append("\u914d\u7f6e\u76ee\u5f55: ").append(manager.getConfigPath());
            JOptionPane.showMessageDialog(frame, status.toString(), "\u66f4\u591a\u4fe1\u606f", 1);
        }
        catch (Exception e) {
            DebugWindow.addLog("DebugWindow", "\u83b7\u53d6\u72b6\u6001\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage(), LogLevel.ERROR);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLog(String tag, String message, LogLevel level) {
        Object object = LOCK;
        synchronized (object) {
            if (!isWindowVisible) {
                DebugWindow.init();
            }
            if (frame != null && textArea != null) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        String timestamp = dateFormat.format(new Date());
                        String colorCode = level.getColor();
                        String logEntry = String.format("%s [%s] [%s]: %s%n", timestamp, level.name(), tag, message);
                        int lineCount = textArea.getLineCount();
                        if (lineCount >= 1000) {
                            try {
                                int endOfFirstLine = textArea.getLineEndOffset(0);
                                textArea.replaceRange("", 0, endOfFirstLine);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        textArea.append(logEntry);
                        textArea.setCaretPosition(textArea.getDocument().getLength());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLog() {
        Object object = LOCK;
        synchronized (object) {
            if (textArea != null) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        textArea.setText("");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = LOCK;
        synchronized (object) {
            if (frame != null) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        frame.dispose();
                        isWindowVisible = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWindowInitialized() {
        Object object = LOCK;
        synchronized (object) {
            return isInitialized && isWindowVisible;
        }
    }

    static {
        dateFormat = new SimpleDateFormat("HH:mm:ss");
        isInitialized = false;
        isWindowVisible = false;
        LOCK = new Object();
    }

    public static enum LogLevel {
        INFO("\u9ed1\u8272"),
        WARN("\u6a59\u8272"),
        ERROR("\u7ea2\u8272");

        private final String color;

        private LogLevel(String color) {
            this.color = color;
        }

        public String getColor() {
            return this.color;
        }
    }
}

