/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.mylog;

import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.mylog.DebugWindow;
import javax.swing.SwingUtilities;

public class mylog {
    private static final Object lock = new Object();
    private static volatile boolean windowInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (ModConfig.getInstance().isDebugWindowEnabled()) {
            SwingUtilities.invokeLater(() -> {
                Object object = lock;
                synchronized (object) {
                    DebugWindow.init();
                    windowInitialized = true;
                    lock.notifyAll();
                }
            });
        } else {
            Object object = lock;
            synchronized (object) {
                windowInitialized = true;
                lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForDebugWindow() {
        if (!ModConfig.getInstance().isDebugWindowEnabled()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            while (!windowInitialized) {
                try {
                    lock.wait(5000L);
                    if (windowInitialized) continue;
                    System.err.println("[mylog] \u7b49\u5f85\u8c03\u8bd5\u7a97\u53e3\u521d\u59cb\u5316\u8d85\u65f6");
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    System.err.println("[mylog] \u7b49\u5f85\u8c03\u8bd5\u7a97\u53e3\u65f6\u88ab\u4e2d\u65ad");
                    break;
                }
            }
        }
    }

    public static void log(String tag, String message) {
        if (ModConfig.getInstance().isDebugWindowEnabled()) {
            DebugWindow.addLog(tag, message, DebugWindow.LogLevel.INFO);
        }
    }

    public static void error(String tag, String message, Throwable e) {
        if (ModConfig.getInstance().isDebugWindowEnabled()) {
            String fullMessage = message;
            if (e != null) {
                fullMessage = fullMessage + "\n" + e;
            }
            DebugWindow.addLog(tag, fullMessage, DebugWindow.LogLevel.ERROR);
        }
    }

    public static void error(String tag, String message) {
        mylog.error(tag, message, null);
    }

    public static void warn(String tag, String message) {
        if (ModConfig.getInstance().isDebugWindowEnabled()) {
            DebugWindow.addLog(tag, message, DebugWindow.LogLevel.WARN);
        }
    }

    public static void closeDebugWindow() {
        if (ModConfig.getInstance().isDebugWindowEnabled()) {
            DebugWindow.close();
        }
    }

    public static void debug(String tag, String s) {
        mylog.log(tag, s);
    }
}

