/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.translation;

import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;

public class ItemTranslationManager {
    private static final String TAG = "ItemTranslationManager";
    private Map<String, String> translationMap = new HashMap<String, String>();
    private boolean initialized = false;
    private boolean hasUnsavedChanges = false;
    private String translationFilePath;

    public boolean initialize(String filePath) {
        if (this.initialized) {
            return true;
        }
        try {
            this.translationFilePath = filePath;
            File file = new File(filePath);
            if (!file.exists()) {
                mylog.warn(TAG, "\u7ffb\u8bd1\u6587\u4ef6\u4e0d\u5b58\u5728: " + filePath);
                this.createEmptyTranslationFile(filePath);
                this.initialized = true;
                return true;
            }
            this.loadTranslations(file);
            this.initialized = true;
            mylog.log(TAG, "\u6210\u529f\u52a0\u8f7d\u7ffb\u8bd1\u6587\u4ef6\uff0c\u5171 " + this.translationMap.size() + " \u6761\u7ffb\u8bd1");
            return true;
        }
        catch (Exception e) {
            mylog.error(TAG, "\u521d\u59cb\u5316\u7ffb\u8bd1\u7ba1\u7406\u5668\u5931\u8d25", e);
            return false;
        }
    }

    public boolean reloadTranslations() {
        try {
            if (this.translationFilePath == null) {
                mylog.warn(TAG, "\u672a\u6307\u5b9a\u7ffb\u8bd1\u6587\u4ef6\u8def\u5f84\uff0c\u65e0\u6cd5\u91cd\u65b0\u52a0\u8f7d");
                return false;
            }
            File file = new File(this.translationFilePath);
            if (!file.exists()) {
                mylog.warn(TAG, "\u7ffb\u8bd1\u6587\u4ef6\u4e0d\u5b58\u5728: " + this.translationFilePath);
                return false;
            }
            if (this.hasUnsavedChanges) {
                mylog.warn(TAG, "\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u7ffb\u8bd1\u66f4\u6539\uff0c\u91cd\u65b0\u52a0\u8f7d\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539");
            }
            this.translationMap.clear();
            this.loadTranslations(file);
            this.initialized = true;
            this.hasUnsavedChanges = false;
            mylog.log(TAG, "\u6210\u529f\u91cd\u65b0\u52a0\u8f7d\u7ffb\u8bd1\u6587\u4ef6\uff0c\u5171 " + this.translationMap.size() + " \u6761\u7ffb\u8bd1");
            return true;
        }
        catch (Exception e) {
            mylog.error(TAG, "\u91cd\u65b0\u52a0\u8f7d\u7ffb\u8bd1\u6587\u4ef6\u5931\u8d25", e);
            return false;
        }
    }

    public int getTranslationCount() {
        return this.translationMap.size();
    }

    private void createEmptyTranslationFile(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            HashMap emptyMap = new HashMap();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(emptyMap);
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write(json);
            }
            mylog.log(TAG, "\u5df2\u521b\u5efa\u7a7a\u7684\u7ffb\u8bd1\u6587\u4ef6: " + filePath);
        }
        catch (Exception e) {
            mylog.error(TAG, "\u521b\u5efa\u7a7a\u7684\u7ffb\u8bd1\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    private void loadTranslations(File file) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse((Reader)reader).getAsJsonObject();
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            this.translationMap = (Map)gson.fromJson((JsonElement)jsonObject, type);
            if (this.translationMap == null) {
                this.translationMap = new HashMap<String, String>();
            }
        }
    }

    public boolean saveTranslations() {
        if (this.translationFilePath == null) {
            mylog.log(TAG, "\u672a\u6307\u5b9a\u7ffb\u8bd1\u6587\u4ef6\u8def\u5f84");
            return false;
        }
        return this.saveTranslations(this.translationFilePath);
    }

    public boolean saveTranslations(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(this.translationMap);
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write(json);
            }
            this.hasUnsavedChanges = false;
            mylog.log(TAG, "\u6210\u529f\u4fdd\u5b58\u7ffb\u8bd1\u6587\u4ef6\uff0c\u5171 " + this.translationMap.size() + " \u6761\u7ffb\u8bd1");
            return true;
        }
        catch (Exception e) {
            mylog.error(TAG, "\u4fdd\u5b58\u7ffb\u8bd1\u6587\u4ef6\u5931\u8d25", e);
            return false;
        }
    }

    public void addOrUpdateTranslation(String original, String translated) {
        if (this.translationMap.containsKey(original)) {
            String existingTranslation = this.translationMap.get(original);
            if (translated != null && !translated.equals(existingTranslation)) {
                this.translationMap.put(original, translated);
                this.hasUnsavedChanges = true;
                return;
            }
            return;
        }
        this.translationMap.put(original, translated);
        this.hasUnsavedChanges = true;
    }

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    public String findTranslation(String original) {
        return this.translationMap.get(original);
    }

    public Map<String, String> getTranslationMap() {
        return this.translationMap;
    }
}

