/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.translation;

import com.cedarxuesong.serverlocalizer.utils.ai.Message;
import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.ai.OpenAIClient;
import com.cedarxuesong.serverlocalizer.utils.ai.OpenAIResponse;
import com.cedarxuesong.serverlocalizer.utils.ai.Usage;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslationConfig;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslationManager;
import com.cedarxuesong.serverlocalizer.utils.translation.ModuleTranslationManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ItemTranslationOnTick {
    private static final String TAG = "ItemTranslationOnTick";
    private static int tickCounter = 0;
    private static final int TRIGGER_INTERVAL = 100;
    private final ExecutorService translationExecutor = Executors.newSingleThreadExecutor();
    private final Set<String> translatingKeys = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean isTranslating = false;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++tickCounter >= 100 & ModConfig.getInstance().isItemTranslationEnabled()) {
            this.onTrigger();
            tickCounter = 0;
        }
    }

    private void onTrigger() {
        ModConfig modConfig = ModConfig.getInstance();
        if (!modConfig.isItemTranslationEnabled()) {
            return;
        }
        if (this.isTranslating) {
            mylog.log(TAG, "\u4e0a\u4e00\u6b21\u7ffb\u8bd1\u4efb\u52a1\u5c1a\u672a\u5b8c\u6210\uff0c\u8df3\u8fc7\u672c\u6b21\u68c0\u67e5");
            return;
        }
        ItemTranslationManager translationManager = ModuleTranslationManager.getInstance().getTranslationManager(ItemTranslationConfig.TranslationModule.ITEM);
        HashMap<String, String> untranslatedEntries = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : translationManager.getTranslationMap().entrySet()) {
            String original = entry.getKey();
            String translated = entry.getValue();
            if (this.translatingKeys.contains(original) || translated != null && !translated.isEmpty()) continue;
            untranslatedEntries.put(original, original);
        }
        if (!untranslatedEntries.isEmpty()) {
            this.isTranslating = true;
            this.startTranslation(untranslatedEntries);
        }
    }

    private void startTranslation(Map<String, String> untranslatedEntries) {
        mylog.log(TAG, "\u53d1\u73b0 " + untranslatedEntries.size() + " \u6761\u672a\u7ffb\u8bd1\u7684\u6761\u76ee\uff0c\u5f00\u59cb\u7ffb\u8bd1...");
        CompletableFuture.runAsync(() -> {
            try {
                ModConfig modConfig = ModConfig.getInstance();
                String apiName = "ItemTranslationApi";
                ArrayList entries = new ArrayList(untranslatedEntries.entrySet());
                int batchSize = 15;
                for (int i = 0; i < entries.size(); i += batchSize) {
                    int endIndex = Math.min(i + batchSize, entries.size());
                    List<Map.Entry<String, String>> batch = entries.subList(i, endIndex);
                    JsonObject translationRequest = new JsonObject();
                    JsonArray textsArray = new JsonArray();
                    for (Map.Entry entry : batch) {
                        String original = (String)entry.getKey();
                        this.translatingKeys.add(original);
                        JsonObject textObj = new JsonObject();
                        textObj.addProperty("key", original);
                        textObj.addProperty("content", original);
                        textsArray.add((JsonElement)textObj);
                    }
                    translationRequest.add("texts", (JsonElement)textsArray);
                    ArrayList<Message> messages = new ArrayList<Message>();
                    messages.add(new Message("system", modConfig.getSystemPrompt(apiName)));
                    messages.add(new Message("user", "/no_think \u9700\u8981\u7ffb\u8bd1\u7684\u5185\u5bb9\uff1a\n" + translationRequest.toString()));
                    OpenAIResponse openAIResponse = OpenAIClient.sendRequestWithConfig(apiName, messages);
                    if (openAIResponse.isSuccess()) {
                        String content = openAIResponse.getContent();
                        this.processTranslationResponse(content, batch);
                        Usage usage = openAIResponse.getUsage();
                        if (usage != null) {
                            modConfig.addAccumulatedTokens(apiName, usage.getTotalTokens());
                        }
                        ModuleTranslationManager.getInstance().saveAllTranslations();
                        mylog.log(TAG, "\u5df2\u4fdd\u5b58\u5f53\u524d\u6279\u6b21\u7ffb\u8bd1 (" + batch.size() + " \u6761)");
                    } else {
                        mylog.log(TAG, "\u7ffb\u8bd1\u8bf7\u6c42\u5931\u8d25: " + openAIResponse.getError());
                        if (Minecraft.func_71410_x() != null) {
                            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a("\u7ffb\u8bd1\u8bf7\u6c42\u5931\u8d25: " + openAIResponse.getError());
                        }
                    }
                    for (Map.Entry<String, String> entry : batch) {
                        this.translatingKeys.remove(entry.getKey());
                    }
                    Thread.sleep(500L);
                }
                mylog.log(TAG, "\u7ffb\u8bd1\u4efb\u52a1\u5b8c\u6210");
            }
            catch (Exception e) {
                mylog.error(TAG, "\u7ffb\u8bd1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
            }
            finally {
                this.isTranslating = false;
            }
        }, this.translationExecutor);
    }

    private String cleanThinkChain(String content) {
        if (content == null) {
            return null;
        }
        return content.replaceAll("<think>[\\s\\S]*?</think>", "").trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTranslationResponse(String content, List<Map.Entry<String, String>> batch) {
        try {
            JsonArray translatedArray;
            content = this.cleanThinkChain(content);
            ItemTranslationManager translationManager = ModuleTranslationManager.getInstance().getTranslationManager(ItemTranslationConfig.TranslationModule.ITEM);
            Gson gson = new Gson();
            JsonElement jsonElement = (JsonElement)gson.fromJson(content, JsonElement.class);
            if (jsonElement.isJsonArray()) {
                translatedArray = jsonElement.getAsJsonArray();
            } else {
                if (!jsonElement.isJsonObject()) {
                    mylog.log(TAG, "\u54cd\u5e94\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e2\u4e0d\u662f\u6570\u7ec4\u4e5f\u4e0d\u662f\u5bf9\u8c61");
                    return;
                }
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject.has("choices") && jsonObject.get("choices").isJsonArray()) {
                    JsonArray choices = jsonObject.getAsJsonArray("choices");
                    if (choices.size() > 0 && choices.get(0).isJsonObject()) {
                        JsonObject firstChoice = choices.get(0).getAsJsonObject();
                        if (firstChoice.has("message") && firstChoice.get("message").isJsonObject()) {
                            String messageContent = firstChoice.getAsJsonObject("message").get("content").getAsString();
                            try {
                                translatedArray = (JsonArray)gson.fromJson(messageContent, JsonArray.class);
                            }
                            catch (Exception e) {
                                mylog.log(TAG, "\u65e0\u6cd5\u4ece\u6d88\u606f\u5185\u5bb9\u89e3\u6790JSON\u6570\u7ec4\uff0c\u539f\u59cb\u5185\u5bb9: " + messageContent);
                                return;
                            }
                        } else {
                            mylog.log(TAG, "\u54cd\u5e94\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u7f3a\u5c11message\u5b57\u6bb5");
                            return;
                        }
                    }
                    mylog.log(TAG, "choices\u6570\u7ec4\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return;
                }
                mylog.log(TAG, "\u54cd\u5e94\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u7f3a\u5c11choices\u6570\u7ec4");
                return;
            }
            if (translatedArray == null) return;
            for (JsonElement element : translatedArray) {
                JsonObject translatedObj;
                if (!element.isJsonObject() || !(translatedObj = element.getAsJsonObject()).has("key")) continue;
                String key = translatedObj.get("key").getAsString();
                String translated = null;
                if (translatedObj.has("translated")) {
                    translated = translatedObj.get("translated").getAsString();
                } else if (translatedObj.has("content")) {
                    translated = translatedObj.get("content").getAsString();
                }
                if (translated == null) {
                    mylog.log(TAG, "\u7ffb\u8bd1\u5bf9\u8c61\u7f3a\u5c11translated\u6216content\u5b57\u6bb5: " + translatedObj);
                    continue;
                }
                if (key == null) continue;
                translationManager.addOrUpdateTranslation(key, translated);
            }
            return;
        }
        catch (Exception e) {
            mylog.error(TAG, "\u5904\u7406\u7ffb\u8bd1\u54cd\u5e94\u65f6\u53d1\u751f\u9519\u8bef", e);
            mylog.log(TAG, "\u539f\u59cb\u54cd\u5e94\u5185\u5bb9: " + content);
        }
    }

    public void shutdown() {
        this.translationExecutor.shutdown();
    }
}

