/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.translation;

import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslationConfig;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslationManager;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ModuleTranslationManager {
    private static final String TAG = "ModuleTranslationManager";
    private static ModuleTranslationManager instance;
    private final Map<ItemTranslationConfig.TranslationModule, ItemTranslationManager> moduleManagers = new ConcurrentHashMap<ItemTranslationConfig.TranslationModule, ItemTranslationManager>();
    private boolean initialized = false;
    private ItemTranslator itemTranslator;

    public static ModuleTranslationManager getInstance() {
        if (instance == null) {
            instance = new ModuleTranslationManager();
        }
        return instance;
    }

    private ModuleTranslationManager() {
        ItemTranslationConfig.ensureDirectoryExists();
    }

    public boolean initialize() {
        try {
            if (this.initialized) {
                return true;
            }
            this.getTranslationManager(ItemTranslationConfig.TranslationModule.ITEM);
            this.itemTranslator = new ItemTranslator();
            this.initialized = true;
            mylog.log(TAG, "\u6a21\u5757\u5316\u7ffb\u8bd1\u7ba1\u7406\u5668\u521d\u59cb\u5316\u5b8c\u6210");
            return true;
        }
        catch (Exception e) {
            mylog.error(TAG, "\u521d\u59cb\u5316\u6a21\u5757\u5316\u7ffb\u8bd1\u7ba1\u7406\u5668\u5931\u8d25", e);
            return false;
        }
    }

    public ItemTranslationManager getTranslationManager(ItemTranslationConfig.TranslationModule module) {
        return this.moduleManagers.computeIfAbsent(module, k -> {
            ItemTranslationManager manager = new ItemTranslationManager();
            manager.initialize(ItemTranslationConfig.getTranslationFile(module));
            return manager;
        });
    }

    public boolean saveAllTranslations() {
        boolean allSaved = true;
        for (Map.Entry<ItemTranslationConfig.TranslationModule, ItemTranslationManager> entry : this.moduleManagers.entrySet()) {
            ItemTranslationManager manager = entry.getValue();
            if (!manager.hasUnsavedChanges()) continue;
            boolean saved = manager.saveTranslations();
            if (saved) {
                mylog.log(TAG, "\u5df2\u4fdd\u5b58\u6a21\u5757 " + (Object)((Object)entry.getKey()) + " \u7684\u7ffb\u8bd1");
                continue;
            }
            allSaved = false;
            mylog.error(TAG, "\u4fdd\u5b58\u6a21\u5757 " + (Object)((Object)entry.getKey()) + " \u7684\u7ffb\u8bd1\u5931\u8d25", new Exception("\u4fdd\u5b58\u5931\u8d25"));
        }
        return allSaved;
    }

    public boolean reloadAllTranslations() {
        boolean allReloaded = true;
        for (Map.Entry<ItemTranslationConfig.TranslationModule, ItemTranslationManager> entry : this.moduleManagers.entrySet()) {
            ItemTranslationManager manager = entry.getValue();
            boolean reloaded = manager.reloadTranslations();
            if (reloaded) {
                mylog.log(TAG, "\u5df2\u91cd\u65b0\u52a0\u8f7d\u6a21\u5757 " + (Object)((Object)entry.getKey()) + " \u7684\u7ffb\u8bd1");
                continue;
            }
            allReloaded = false;
            mylog.error(TAG, "\u91cd\u65b0\u52a0\u8f7d\u6a21\u5757 " + (Object)((Object)entry.getKey()) + " \u7684\u7ffb\u8bd1\u5931\u8d25", new Exception("\u91cd\u65b0\u52a0\u8f7d\u5931\u8d25"));
        }
        return allReloaded;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean hasUnsavedChanges() {
        for (ItemTranslationManager manager : this.moduleManagers.values()) {
            if (!manager.hasUnsavedChanges()) continue;
            return true;
        }
        return false;
    }

    public ItemTranslator getItemTranslator() {
        if (this.itemTranslator == null) {
            this.itemTranslator = new ItemTranslator();
        }
        return this.itemTranslator;
    }

    public String getConfigPath() {
        return ItemTranslationConfig.getConfigRoot();
    }
}

