/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.translation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextProcessor {
    private static final String TAG = "TextProcessor";
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("\u00a7[0-9a-fk-or]");
    private static final Pattern FRACTION_NUMBER_PATTERN = Pattern.compile("\\d+[,./|\\\\;:]\\d+");
    private static final Pattern SEPARATOR_NUMBER_PATTERN = Pattern.compile("\\d+(?:[,./|\\\\;:]\\d+)+");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final String DYNAMIC_CONTENT_PLACEHOLDER = "{\u3036}";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\u3036\\}");

    private static String replaceColorCodesWithPlaceholders(String text, ColorCodeMapping mapping) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = COLOR_CODE_PATTERN.matcher(text);
        while (matcher.find()) {
            String colorCode = matcher.group();
            String placeholder = mapping.addColorCode(colorCode);
            matcher.appendReplacement(sb, placeholder);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static boolean isPartOfOtherNumber(String number, List<String> existingNumbers) {
        for (String existingNumber : existingNumbers) {
            char nextChar;
            char prevChar;
            if (existingNumber.equals(number) || !existingNumber.contains(number)) continue;
            int index = existingNumber.indexOf(number);
            boolean isIndependent = true;
            if (index > 0 && Character.isDigit(prevChar = existingNumber.charAt(index - 1))) {
                isIndependent = false;
            }
            if (index + number.length() < existingNumber.length() && Character.isDigit(nextChar = existingNumber.charAt(index + number.length()))) {
                isIndependent = false;
            }
            if (isIndependent) continue;
            return true;
        }
        return false;
    }

    public static TemplateResult convertToTemplate(String text) {
        if (text == null || text.isEmpty()) {
            return new TemplateResult(text, new ArrayList<String>());
        }
        ColorCodeMapping colorMapping = new ColorCodeMapping();
        String processedText = TextProcessor.replaceColorCodesWithPlaceholders(text, colorMapping);
        ArrayList<String> dynamicContentWithPlaceholders = new ArrayList<String>();
        ArrayList<String> dynamicContentOriginal = new ArrayList<String>();
        Matcher fractionNumberMatcher = FRACTION_NUMBER_PATTERN.matcher(processedText);
        while (fractionNumberMatcher.find()) {
            String number = fractionNumberMatcher.group();
            dynamicContentWithPlaceholders.add(number);
            String original = colorMapping.restoreColorCodes(number);
            dynamicContentOriginal.add(original);
        }
        Matcher separatorNumberMatcher = SEPARATOR_NUMBER_PATTERN.matcher(processedText);
        while (separatorNumberMatcher.find()) {
            String number = separatorNumberMatcher.group();
            if (dynamicContentWithPlaceholders.contains(number)) continue;
            dynamicContentWithPlaceholders.add(number);
            String original = colorMapping.restoreColorCodes(number);
            dynamicContentOriginal.add(original);
        }
        Matcher numberMatcher = NUMBER_PATTERN.matcher(processedText);
        while (numberMatcher.find()) {
            String number = numberMatcher.group();
            if (TextProcessor.isPartOfOtherNumber(number, dynamicContentWithPlaceholders)) continue;
            dynamicContentWithPlaceholders.add(number);
            String original = colorMapping.restoreColorCodes(number);
            dynamicContentOriginal.add(original);
        }
        if (dynamicContentWithPlaceholders.isEmpty()) {
            return new TemplateResult(text, dynamicContentOriginal);
        }
        ArrayList combinedList = new ArrayList();
        for (int i = 0; i < dynamicContentWithPlaceholders.size(); ++i) {
            combinedList.add(new Pair(dynamicContentWithPlaceholders.get(i), dynamicContentOriginal.get(i)));
        }
        combinedList.sort((a, b) -> ((String)b.first).length() - ((String)a.first).length());
        dynamicContentWithPlaceholders.clear();
        dynamicContentOriginal.clear();
        for (Pair pair : combinedList) {
            dynamicContentWithPlaceholders.add((String)pair.first);
            dynamicContentOriginal.add((String)pair.second);
        }
        String template = processedText;
        for (String content : dynamicContentWithPlaceholders) {
            template = template.replace(content, DYNAMIC_CONTENT_PLACEHOLDER);
        }
        template = colorMapping.restoreColorCodes(template);
        return new TemplateResult(template, dynamicContentOriginal);
    }

    public static String fillTemplate(String template, List<String> dynamicContent) {
        if (dynamicContent.isEmpty()) {
            return template;
        }
        ColorCodeMapping colorMapping = new ColorCodeMapping();
        String processedTemplate = TextProcessor.replaceColorCodesWithPlaceholders(template, colorMapping);
        ArrayList<String> processedDynamicContent = new ArrayList<String>();
        for (String content : dynamicContent) {
            String processed = TextProcessor.replaceColorCodesWithPlaceholders(content, colorMapping);
            processedDynamicContent.add(processed);
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(processedTemplate);
        StringBuffer sb = new StringBuffer();
        for (int index = 0; matcher.find() && index < processedDynamicContent.size(); ++index) {
            String replacement = (String)processedDynamicContent.get(index);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return colorMapping.restoreColorCodes(sb.toString());
    }

    public static class TemplateResult {
        private final String template;
        private final List<String> dynamicContent;

        public TemplateResult(String template, List<String> dynamicContent) {
            this.template = template;
            this.dynamicContent = dynamicContent;
        }

        public String getTemplate() {
            return this.template;
        }

        public List<String> getDynamicContent() {
            return this.dynamicContent;
        }
    }

    private static class Pair<F, S> {
        public final F first;
        public final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }
    }

    private static class ColorCodeMapping {
        Map<String, String> codeToPlaceholder = new HashMap<String, String>();
        Map<String, String> placeholderToCode = new HashMap<String, String>();
        int counter = 0;

        private ColorCodeMapping() {
        }

        String addColorCode(String colorCode) {
            String placeholder = this.codeToPlaceholder.get(colorCode);
            if (placeholder == null) {
                char unicodeChar = (char)(57344 + this.counter++);
                placeholder = String.valueOf(unicodeChar);
                this.codeToPlaceholder.put(colorCode, placeholder);
                this.placeholderToCode.put(placeholder, colorCode);
            }
            return placeholder;
        }

        String restoreColorCodes(String text) {
            String result = text;
            for (Map.Entry<String, String> entry : this.placeholderToCode.entrySet()) {
                result = result.replace(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }
}

