/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.mixins.mixinGUI;

import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.cedarxuesong.serverlocalizer.utils.translation.ChatMessageCache;
import java.util.UUID;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={GuiNewChat.class})
public class mixinGuiChat {
    @Unique
    private static final String cedarServerLocalizer$TAG = "ChatMixin";

    @ModifyArg(method={"printChatMessageWithOptionalDeletion"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiNewChat;setChatLine(Lnet/minecraft/util/IChatComponent;IIZ)V"), index=0)
    private IChatComponent onChatMessage(IChatComponent component) {
        try {
            if (!ModConfig.getInstance().isChatTranslationEnabled()) {
                return component;
            }
            String messageId = UUID.randomUUID().toString();
            ChatMessageCache.getInstance().cacheMessage(messageId, component);
            ChatComponentText translationMark = new ChatComponentText(" \u00a7r\u00a77[T]\u00a7r");
            ChatStyle style = new ChatStyle();
            style.func_150238_a(EnumChatFormatting.GRAY);
            ChatComponentText hoverText = new ChatComponentText("\u00a7b\u70b9\u51fb\u7ffb\u8bd1\u6b64\u6d88\u606f \u00a7r\u00a7aby Serverlocalizer \n\u00a7r\u00a77MessageID: " + messageId);
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)hoverText));
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/serverlocalizer translate " + messageId));
            translationMark.func_150255_a(style);
            return component.func_150257_a((IChatComponent)translationMark);
        }
        catch (Exception e) {
            mylog.error(cedarServerLocalizer$TAG, "\u5904\u7406\u804a\u5929\u6d88\u606f\u65f6\u53d1\u751f\u9519\u8bef", e);
            return component;
        }
    }
}

