/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.mixins.mixinPacket;

import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.cedarxuesong.serverlocalizer.utils.translation.ItemTranslator;
import com.cedarxuesong.serverlocalizer.utils.translation.ModuleTranslationManager;
import com.cedarxuesong.serverlocalizer.utils.translation.TextProcessor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.S30PacketWindowItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={S30PacketWindowItems.class})
public class HookWindowItemsPacket {
    @Unique
    private static final String cedarServerLocalizer$TAG = "ItemPacket";
    @Shadow
    private int field_148914_a;
    @Shadow
    private ItemStack[] field_148913_b;

    @Inject(method={"readPacketData"}, at={@At(value="RETURN")})
    public void onReadPacketData(CallbackInfo ci) {
        if (this.field_148913_b != null && ModConfig.getInstance().isItemTranslationEnabled()) {
            ModConfig modConfig = ModConfig.getInstance();
            if (!modConfig.isItemTranslationEnabled()) {
                return;
            }
            ModuleTranslationManager manager = ModuleTranslationManager.getInstance();
            if (!manager.isInitialized()) {
                manager.initialize();
            }
            ItemTranslator itemTranslator = manager.getItemTranslator();
            for (int i = 0; i < this.field_148913_b.length; ++i) {
                ItemStack item = this.field_148913_b[i];
                if (item == null) continue;
                try {
                    String originalName;
                    TextProcessor.TemplateResult nameResult;
                    String translatedTemplate;
                    String translatedName;
                    NBTTagCompound nbt = item.func_77978_p();
                    if (nbt == null) {
                        nbt = new NBTTagCompound();
                        item.func_77982_d(nbt);
                    }
                    NBTTagCompound display = nbt.func_74775_l("display");
                    if (!nbt.func_150297_b("display", 10)) {
                        display = new NBTTagCompound();
                        nbt.func_74782_a("display", (NBTBase)display);
                    }
                    if (display.func_150297_b("Name", 8) && modConfig.isItemNameTranslationEnabled() && !(translatedName = TextProcessor.fillTemplate(translatedTemplate = itemTranslator.translate((nameResult = TextProcessor.convertToTemplate(originalName = display.func_74779_i("Name"))).getTemplate()), nameResult.getDynamicContent())).equals(originalName)) {
                        display.func_74778_a("Name", translatedName);
                    }
                    if (!display.func_150297_b("Lore", 9) || !modConfig.isItemLoreTranslationEnabled()) continue;
                    NBTTagList lore = display.func_150295_c("Lore", 8);
                    NBTTagList newLore = new NBTTagList();
                    boolean hasChanges = false;
                    for (int j = 0; j < lore.func_74745_c(); ++j) {
                        String originalLine = lore.func_150307_f(j);
                        TextProcessor.TemplateResult lineResult = TextProcessor.convertToTemplate(originalLine);
                        String translatedTemplate2 = itemTranslator.translate(lineResult.getTemplate());
                        String translatedLine = TextProcessor.fillTemplate(translatedTemplate2, lineResult.getDynamicContent());
                        newLore.func_74742_a((NBTBase)new NBTTagString(translatedLine));
                        if (translatedLine.equals(originalLine)) continue;
                        hasChanges = true;
                    }
                    if (!hasChanges) continue;
                    display.func_74782_a("Lore", (NBTBase)newLore);
                    continue;
                }
                catch (Exception e) {
                    mylog.error(cedarServerLocalizer$TAG, "\u5904\u7406\u69fd\u4f4d " + i + " \u7684\u7269\u54c1\u6570\u636e\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                }
            }
        }
    }
}

