/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils;

import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.commands.ServerLocalizerCommand;
import com.cedarxuesong.serverlocalizer.utils.gui.ConfigGui;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.cedarxuesong.serverlocalizer.utils.translation.ModuleTranslationManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EventHandler {
    private static final String TAG = "EventHandler";
    private boolean isConnected = false;
    private boolean needsSaving = false;
    private int saveRetryCount = 0;
    private static final int MAX_SAVE_RETRIES = 3;

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        try {
            boolean initialized;
            mylog.log(TAG, "\u5ba2\u6237\u7aef\u5df2\u8fde\u63a5\u5230\u670d\u52a1\u5668\uff0c\u521d\u59cb\u5316\u7ffb\u8bd1\u7cfb\u7edf");
            this.isConnected = true;
            this.needsSaving = false;
            this.saveRetryCount = 0;
            ModuleTranslationManager manager = ModuleTranslationManager.getInstance();
            if (!manager.isInitialized() && !(initialized = manager.initialize())) {
                mylog.error(TAG, "\u7ffb\u8bd1\u7cfb\u7edf\u521d\u59cb\u5316\u5931\u8d25", new Exception("\u521d\u59cb\u5316\u5931\u8d25"));
            }
            if (!ModConfig.getInstance().isChatTranslationEnabled() & !ModConfig.getInstance().isItemTranslationEnabled()) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a("\u00a7r\u00a7e[ServerLocalizer] \u5f53\u524d\u672a\u542f\u7528\u4efb\u4f55\u529f\u80fd\uff0c\u8bf7\u5728\u00a7r\u00a7b\u6a21\u7ec4\u914d\u7f6e\u00a7r\u00a7e\u4e2d\u8bbe\u7f6e\uff01");
            }
        }
        catch (Exception e) {
            mylog.error(TAG, "\u5904\u7406\u5ba2\u6237\u7aef\u8fde\u63a5\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @SubscribeEvent
    public void onClientDisconnectionFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        try {
            mylog.log(TAG, "\u68c0\u6d4b\u5230\u65ad\u5f00\u8fde\u63a5\u4e8b\u4ef6");
            this.handleDisconnection("\u65ad\u5f00\u8fde\u63a5\u4e8b\u4ef6");
        }
        catch (Exception e) {
            mylog.error(TAG, "\u5904\u7406\u5ba2\u6237\u7aef\u65ad\u5f00\u8fde\u63a5\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        try {
            if (event.world.field_72995_K && this.isConnected) {
                mylog.log(TAG, "\u68c0\u6d4b\u5230\u4e16\u754c\u5378\u8f7d\u4e8b\u4ef6");
                this.handleDisconnection("\u4e16\u754c\u5378\u8f7d\u4e8b\u4ef6");
            }
        }
        catch (Exception e) {
            mylog.error(TAG, "\u5904\u7406\u4e16\u754c\u5378\u8f7d\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.needsSaving && this.saveRetryCount < 3) {
            try {
                mylog.log(TAG, "\u5c1d\u8bd5\u4fdd\u5b58\u7ffb\u8bd1\u6587\u4ef6 (\u91cd\u8bd5\u6b21\u6570: " + this.saveRetryCount + ")");
                ModuleTranslationManager manager = ModuleTranslationManager.getInstance();
                if (manager.hasUnsavedChanges()) {
                    boolean saved = manager.saveAllTranslations();
                    if (saved) {
                        mylog.log(TAG, "\u6240\u6709\u7ffb\u8bd1\u6a21\u5757\u4fdd\u5b58\u6210\u529f");
                        this.needsSaving = false;
                        this.saveRetryCount = 0;
                    } else {
                        ++this.saveRetryCount;
                        mylog.warn(TAG, "\u90e8\u5206\u7ffb\u8bd1\u6a21\u5757\u4fdd\u5b58\u5931\u8d25\uff0c\u5c06\u5728\u4e0b\u4e00\u4e2atick\u91cd\u8bd5");
                    }
                } else {
                    this.needsSaving = false;
                    this.saveRetryCount = 0;
                }
            }
            catch (Exception e) {
                mylog.error(TAG, "\u5728tick\u4e8b\u4ef6\u4e2d\u4fdd\u5b58\u7ffb\u8bd1\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", e);
                ++this.saveRetryCount;
            }
        }
        if (event.phase == TickEvent.Phase.END && ServerLocalizerCommand.shouldOpenConfigGui && Minecraft.func_71410_x().field_71462_r == null) {
            mylog.log(TAG, "\u68c0\u6d4b\u5230GUI\u6807\u5fd7\uff0c\u6b63\u5728\u6253\u5f00ConfigGui...");
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ConfigGui(null));
            ServerLocalizerCommand.shouldOpenConfigGui = false;
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiChat) {
            return;
        }
    }

    private void handleDisconnection(String trigger) {
        if (this.isConnected) {
            mylog.log(TAG, "\u89e6\u53d1\u4fdd\u5b58\u64cd\u4f5c (\u6765\u81ea: " + trigger + ")");
            this.isConnected = false;
            this.needsSaving = true;
            this.saveRetryCount = 0;
            try {
                ModuleTranslationManager manager = ModuleTranslationManager.getInstance();
                if (manager.hasUnsavedChanges()) {
                    boolean saved = manager.saveAllTranslations();
                    if (saved) {
                        mylog.log(TAG, "\u6240\u6709\u7ffb\u8bd1\u6a21\u5757\u7acb\u5373\u4fdd\u5b58\u6210\u529f");
                        this.needsSaving = false;
                    } else {
                        mylog.warn(TAG, "\u90e8\u5206\u7ffb\u8bd1\u6a21\u5757\u7acb\u5373\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u52a0\u5165\u91cd\u8bd5\u961f\u5217");
                    }
                } else {
                    this.needsSaving = false;
                }
            }
            catch (Exception e) {
                mylog.error(TAG, "\u7acb\u5373\u4fdd\u5b58\u7ffb\u8bd1\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u5df2\u52a0\u5165\u91cd\u8bd5\u961f\u5217", e);
            }
        }
    }
}

