/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.ai;

public class Message {
    private String role;
    private String content;

    public Message(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toJson() {
        return String.format("{\"role\":\"%s\",\"content\":\"%s\"}", this.escapeJson(this.role), this.escapeJson(this.content));
    }

    private String escapeJson(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        block9: for (char c : input.toCharArray()) {
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        result.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

