/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.ai;

import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class ModConfig {
    private static final String TAG = "ModConfig";
    private static final String CONFIG_FILE = "config/serverlocalizer/ModConfig.json";
    private static final String DEFAULT_CONFIG = "{\n    \"ItemTranslationApi\": {\n        \"BaseUrl\": \"\",\n        \"ApiKey\": \"\",\n        \"Model\": \"\",\n        \"Temperature\": 0.5,\n        \"SystemPrompt\": \"\u4f60\u662f\u4e00\u4e2a\u4e13\u4e1a\u7684\u6211\u7684\u4e16\u754c\u7ffb\u8bd1\u52a9\u624b.\u4f1a\u4e25\u683c\u9075\u5faa\u4ee5\u4e0b\u89c4\u5219: \u5c06\u539f\u6587\u7ffb\u8bd1\u81f3\u4e2d\u6587\uff0c\u4fdd\u7559\u90e8\u5206\u82f1\u6587\u540d\u8bcd\u4ee5\u4fdd\u6301\u6e38\u620f\u672f\u8bed\u7684\u51c6\u786e\u6027\u3002\u4fdd\u6301\u6240\u6709\u683c\u5f0f\u6807\u8bb0(\u5982\u00a7\u540e\u7684\u989c\u8272\u4ee3\u7801).\u7ffb\u8bd1\u8981\u7b80\u6d01\u81ea\u7136\uff0c\u7b26\u5408\u6e38\u620f\u8868\u8fbe\u4e60\u60ef. \u53ea\u8fd4\u56de\u7ffb\u8bd1\u540e\u7684JSON\u6570\u7ec4\uff0c\u683c\u5f0f\u4e3a:[{{\\\"key\\\": \\\"\u539fkey\\\", \\\"translated\\\": \\\"\u7ffb\u8bd1\u540e\u7684\u6587\u672c\\\"}}}]\",\n        \"TotalTokens\": 0\n    },\n    \"ChatTranslationApi\": {\n        \"BaseUrl\": \"\",\n        \"ApiKey\": \"\",\n        \"Model\": \"\",\n        \"Temperature\": 0.5,\n        \"SystemPrompt\": \"\u4f60\u662f\u4e00\u4e2a\u7ffb\u8bd1\u52a9\u624b\uff0c\u8bf7\u5c06\u4ee5\u4e0b\u6587\u672c\u7ffb\u8bd1\u6210\u4e2d\u6587\uff0c\u4fdd\u7559\u683c\u5f0f\u5b57\u7b26\u00a7*\uff0c\u4ec5\u8f93\u51fa\u8bd1\u6587\u3002\",\n        \"useStream\": false\n    },\n    \"GeneralSettings\": {\n        \"EnableItemTranslation\": false,\n        \"EnableItemNameTranslation\": false,\n        \"EnableItemLoreTranslation\": false,\n        \"EnableChatTranslation\": false,\n        \"EnableDebugWindow\": false\n    }\n}";
    private static ModConfig instance;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private JsonObject configData;

    private ModConfig() {
    }

    public static synchronized ModConfig getInstance() {
        if (instance == null) {
            instance = new ModConfig();
            instance.loadConfig();
        }
        return instance;
    }

    public boolean initialize() {
        try {
            this.loadConfig();
            mylog.log(TAG, "API\u914d\u7f6e\u5df2\u91cd\u65b0\u521d\u59cb\u5316");
            return true;
        }
        catch (Exception e) {
            mylog.error(TAG, "\u521d\u59cb\u5316API\u914d\u7f6e\u65f6\u51fa\u9519", e);
            return false;
        }
    }

    private void loadConfig() {
        File configFile = new File(CONFIG_FILE);
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    writer.write(DEFAULT_CONFIG);
                }
                this.configData = this.parseJson(DEFAULT_CONFIG);
                mylog.log(TAG, "\u521b\u5efa\u4e86\u9ed8\u8ba4API\u914d\u7f6e\u6587\u4ef6");
            }
            catch (IOException e) {
                mylog.error(TAG, "\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519", e);
                this.configData = this.parseJson(DEFAULT_CONFIG);
            }
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                this.configData = this.parseJson(content.toString());
                mylog.log(TAG, "\u6210\u529f\u52a0\u8f7dAPI\u914d\u7f6e\u6587\u4ef6");
            }
            catch (Exception e) {
                mylog.error(TAG, "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e", e);
                this.configData = this.parseJson(DEFAULT_CONFIG);
            }
        }
    }

    private JsonObject parseJson(String json) {
        try {
            JsonParser parser = new JsonParser();
            return parser.parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            mylog.error(TAG, "\u89e3\u6790JSON\u65f6\u51fa\u9519", e);
            return new JsonObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveConfig() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(CONFIG_FILE, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.write(this.gson.toJson((JsonElement)this.configData));
            mylog.log(TAG, "\u6210\u529f\u4fdd\u5b58API\u914d\u7f6e");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            mylog.error(TAG, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u9519", e);
            return false;
        }
    }

    public void resetToDefaults() {
        this.configData = this.parseJson(DEFAULT_CONFIG);
        this.saveConfig();
        this.initialize();
        mylog.log(TAG, "\u914d\u7f6e\u5df2\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c");
    }

    private JsonObject getOrCreateApiSettings(String apiName) {
        if (this.configData.has(apiName) && this.configData.get(apiName).isJsonObject()) {
            return this.configData.getAsJsonObject(apiName);
        }
        JsonObject newApiSettings = new JsonObject();
        this.configData.add(apiName, (JsonElement)newApiSettings);
        mylog.log(TAG, "\u521b\u5efa\u4e86\u7f3a\u5931\u7684\u914d\u7f6e\u8282: " + apiName);
        return newApiSettings;
    }

    private JsonObject getOrCreateGeneralSettings() {
        if (this.configData.has("GeneralSettings") && this.configData.get("GeneralSettings").isJsonObject()) {
            return this.configData.getAsJsonObject("GeneralSettings");
        }
        JsonObject newGeneralSettings = new JsonObject();
        this.configData.add("GeneralSettings", (JsonElement)newGeneralSettings);
        mylog.log(TAG, "\u521b\u5efa\u4e86\u7f3a\u5931\u7684\u914d\u7f6e\u8282: GeneralSettings");
        return newGeneralSettings;
    }

    public String getBaseUrl(String apiName) {
        JsonObject apiSettings = this.getOrCreateApiSettings(apiName);
        if (apiSettings.has("BaseUrl") && apiSettings.get("BaseUrl").isJsonPrimitive()) {
            return apiSettings.get("BaseUrl").getAsString();
        }
        apiSettings.addProperty("BaseUrl", "");
        return "";
    }

    public String getApiKey(String apiName) {
        JsonObject apiSettings = this.getOrCreateApiSettings(apiName);
        if (apiSettings.has("ApiKey") && apiSettings.get("ApiKey").isJsonPrimitive()) {
            return apiSettings.get("ApiKey").getAsString();
        }
        apiSettings.addProperty("ApiKey", "");
        return "";
    }

    public String getModel(String apiName) {
        JsonObject apiSettings = this.getOrCreateApiSettings(apiName);
        if (apiSettings.has("Model") && apiSettings.get("Model").isJsonPrimitive()) {
            return apiSettings.get("Model").getAsString();
        }
        apiSettings.addProperty("Model", "");
        return "";
    }

    public double getTemperature(String apiName) {
        JsonObject apiSettings = this.getOrCreateApiSettings(apiName);
        if (apiSettings.has("Temperature") && apiSettings.get("Temperature").isJsonPrimitive()) {
            try {
                return apiSettings.get("Temperature").getAsDouble();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        apiSettings.addProperty("Temperature", (Number)0.5);
        return 0.5;
    }

    public String getSystemPrompt(String apiName) {
        JsonObject apiSettings = this.getOrCreateApiSettings(apiName);
        if (apiSettings.has("SystemPrompt") && apiSettings.get("SystemPrompt").isJsonPrimitive()) {
            return apiSettings.get("SystemPrompt").getAsString();
        }
        String defaultPrompt = "You are a helpful assistant.";
        apiSettings.addProperty("SystemPrompt", defaultPrompt);
        return defaultPrompt;
    }

    public void setBaseUrl(String apiName, String baseUrl) {
        this.getOrCreateApiSettings(apiName).addProperty("BaseUrl", baseUrl);
    }

    public void setApiKey(String apiName, String apiKey) {
        this.getOrCreateApiSettings(apiName).addProperty("ApiKey", apiKey);
    }

    public void setModel(String apiName, String model) {
        this.getOrCreateApiSettings(apiName).addProperty("Model", model);
    }

    public void setTemperature(String apiName, double temperature) {
        this.getOrCreateApiSettings(apiName).addProperty("Temperature", (Number)temperature);
    }

    public void setSystemPrompt(String apiName, String systemPrompt) {
        this.getOrCreateApiSettings(apiName).addProperty("SystemPrompt", systemPrompt);
    }

    public long getAccumulatedTokens(String apiName) {
        JsonObject apiSettings = this.getOrCreateApiSettings(apiName);
        if (apiSettings.has("TotalTokens") && apiSettings.get("TotalTokens").isJsonPrimitive()) {
            try {
                return apiSettings.get("TotalTokens").getAsLong();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        apiSettings.addProperty("TotalTokens", (Number)0L);
        return 0L;
    }

    public void addAccumulatedTokens(String apiName, long tokensToAdd) {
        long currentTokens = this.getAccumulatedTokens(apiName);
        this.getOrCreateApiSettings(apiName).addProperty("TotalTokens", (Number)(currentTokens + tokensToAdd));
    }

    private boolean getGeneralSetting(String key) {
        JsonObject generalSettings = this.getOrCreateGeneralSettings();
        if (generalSettings.has(key) && generalSettings.get(key).isJsonPrimitive()) {
            try {
                return generalSettings.get(key).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        generalSettings.addProperty(key, Boolean.valueOf(false));
        return false;
    }

    private void setGeneralSetting(String key, boolean value) {
        this.getOrCreateGeneralSettings().addProperty(key, Boolean.valueOf(value));
    }

    public boolean isItemTranslationEnabled() {
        return this.getGeneralSetting("EnableItemTranslation");
    }

    public boolean isItemNameTranslationEnabled() {
        return this.getGeneralSetting("EnableItemNameTranslation");
    }

    public void setItemNameTranslationEnabled(boolean enabled) {
        this.setGeneralSetting("EnableItemNameTranslation", enabled);
    }

    public boolean isItemLoreTranslationEnabled() {
        return this.getGeneralSetting("EnableItemLoreTranslation");
    }

    public void setItemLoreTranslationEnabled(boolean enabled) {
        this.setGeneralSetting("EnableItemLoreTranslation", enabled);
    }

    public boolean isChatTranslationEnabled() {
        return this.getGeneralSetting("EnableChatTranslation");
    }

    public void setChatTranslationEnabled(boolean enabled) {
        this.setGeneralSetting("EnableChatTranslation", enabled);
    }

    public void setItemTranslationEnabled(boolean itemEnabled) {
        this.setGeneralSetting("EnableItemTranslation", itemEnabled);
    }

    public boolean isChatStreamEnabled() {
        JsonObject chatApiSettings = this.getOrCreateApiSettings("ChatTranslationApi");
        if (chatApiSettings.has("useStream") && chatApiSettings.get("useStream").isJsonPrimitive()) {
            try {
                return chatApiSettings.get("useStream").getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        chatApiSettings.addProperty("useStream", Boolean.valueOf(false));
        return false;
    }

    public void setChatStreamEnabled(boolean enabled) {
        this.getOrCreateApiSettings("ChatTranslationApi").addProperty("useStream", Boolean.valueOf(enabled));
    }

    public boolean isDebugWindowEnabled() {
        return this.getGeneralSetting("EnableDebugWindow");
    }

    public void setDebugWindowEnabled(boolean enabled) {
        this.setGeneralSetting("EnableDebugWindow", enabled);
    }
}

