/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.ai;

import com.cedarxuesong.serverlocalizer.utils.ai.Message;
import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.ai.OpenAIResponse;
import com.cedarxuesong.serverlocalizer.utils.ai.Usage;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public class OpenAIClient {
    private static final String TAG = "OpenAIClient";
    private static final ExecutorService streamExecutor = Executors.newCachedThreadPool();

    public static OpenAIResponse sendRequestWithConfig(String apiName, List<Message> messages) {
        ModConfig config = ModConfig.getInstance();
        String baseUrl = config.getBaseUrl(apiName);
        String apiKey = config.getApiKey(apiName);
        String model = config.getModel(apiName);
        double temperature = config.getTemperature(apiName);
        return OpenAIClient.sendRequest(baseUrl, apiKey, model, messages, temperature);
    }

    public static void sendStreamRequestWithConfig(String apiName, List<Message> messages, Consumer<String> onChunk, Consumer<Usage> onComplete, Consumer<String> onError) {
        streamExecutor.submit(() -> {
            ModConfig config = ModConfig.getInstance();
            String baseUrl = config.getBaseUrl(apiName);
            String apiKey = config.getApiKey(apiName);
            String model = config.getModel(apiName);
            double temperature = config.getTemperature(apiName);
            HttpURLConnection connection = null;
            Usage usage = null;
            try {
                URL url = new URL(baseUrl + "/chat/completions");
                connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Authorization", "Bearer " + apiKey);
                connection.setDoOutput(true);
                String requestBody = OpenAIClient.buildRequestBody(model, messages, temperature, true);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = requestBody.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode >= 400) {
                    StringBuilder errorResponse = new StringBuilder();
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            errorResponse.append(line);
                        }
                    }
                    onError.accept("API Error: " + responseCode + " - " + errorResponse.toString());
                    return;
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        String content;
                        if (!line.startsWith("data:")) continue;
                        String data = line.substring(5).trim();
                        if ("[DONE]".equals(data)) {
                            break;
                        }
                        Usage chunkUsage = OpenAIClient.parseUsageFromStreamData(data);
                        if (chunkUsage != null) {
                            usage = chunkUsage;
                        }
                        if ((content = OpenAIClient.parseContentFromStreamData(data)) == null) continue;
                        onChunk.accept(content);
                    }
                }
            }
            catch (IOException e) {
                mylog.error(TAG, "\u53d1\u9001\u6d41\u5f0fAPI\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef", e);
                onError.accept("\u8bf7\u6c42\u9519\u8bef: " + e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                onComplete.accept(usage);
            }
        });
    }

    public static OpenAIResponse sendRequest(String baseUrl, String apiKey, String model, List<Message> messages) {
        return OpenAIClient.sendRequest(baseUrl, apiKey, model, messages, 0.7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenAIResponse sendRequest(String baseUrl, String apiKey, String model, List<Message> messages, double temperature) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(baseUrl + "/chat/completions");
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", "Bearer " + apiKey);
            connection.setDoOutput(true);
            String requestBody = OpenAIClient.buildRequestBody(model, messages, temperature, false);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = requestBody.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            StringBuilder response = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream(), StandardCharsets.UTF_8));
            Object object = null;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (br != null) {
                    if (object != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        br.close();
                    }
                }
            }
            String error = null;
            if (responseCode >= 400) {
                error = response.toString();
                mylog.log(TAG, "API\u8bf7\u6c42\u5931\u8d25: " + error);
            }
            object = new OpenAIResponse(response.toString(), error, responseCode);
            return object;
        }
        catch (IOException e) {
            mylog.error(TAG, "\u53d1\u9001API\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef", e);
            OpenAIResponse openAIResponse = new OpenAIResponse(null, e.getMessage(), 500);
            return openAIResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static String parseContentFromStreamData(String data) {
        try {
            Pattern pattern = Pattern.compile("\"content\":\"(.*?)\"");
            Matcher matcher = pattern.matcher(data);
            if (matcher.find()) {
                return matcher.group(1).replace("\\\\", "\\").replace("\\\"", "\"").replace("\\n", "\n").replace("\\t", "\t");
            }
        }
        catch (Exception e) {
            mylog.error(TAG, "\u89e3\u6790\u6d41\u6570\u636e\u5931\u8d25: " + data, e);
        }
        return null;
    }

    private static Usage parseUsageFromStreamData(String data) {
        try {
            if (data.contains("\"usage\"")) {
                OpenAIResponse mockResponse = new OpenAIResponse(data, null, 200);
                return mockResponse.extractUsage();
            }
        }
        catch (Exception e) {
            mylog.error(TAG, "\u89e3\u6790\u6d41\u6570\u636e\u4e2d\u7684Usage\u5931\u8d25: " + data, e);
        }
        return null;
    }

    private static String buildRequestBody(String model, List<Message> messages, double temperature, boolean stream) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"model\":\"").append(model).append("\",");
        json.append("\"messages\":[");
        for (int i = 0; i < messages.size(); ++i) {
            if (i > 0) {
                json.append(",");
            }
            json.append(messages.get(i).toJson());
        }
        json.append("],");
        json.append("\"temperature\":").append(temperature).append(",");
        json.append("\"stream\":").append(stream);
        json.append("}");
        return json.toString();
    }
}

