/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.ai;

import com.cedarxuesong.serverlocalizer.utils.ai.Usage;

public class OpenAIResponse {
    private final String content;
    private final String error;
    private final int statusCode;
    private final Usage usage;

    public OpenAIResponse(String content, String error, int statusCode) {
        this.content = content;
        this.error = error;
        this.statusCode = statusCode;
        this.usage = this.extractUsage();
    }

    public String getContent() {
        return this.content;
    }

    public String getError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300 && this.error == null;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String extractMessageContent() {
        if (!this.isSuccess() || this.content == null) {
            return null;
        }
        try {
            int choicesIndex = this.content.indexOf("\"choices\"");
            if (choicesIndex == -1) {
                return null;
            }
            int messageIndex = this.content.indexOf("\"message\"", choicesIndex);
            if (messageIndex == -1) {
                return null;
            }
            int contentIndex = this.content.indexOf("\"content\"", messageIndex);
            if (contentIndex == -1) {
                return null;
            }
            int startQuote = this.content.indexOf("\"", contentIndex + 9);
            if (startQuote == -1) {
                return null;
            }
            int endQuote = this.findClosingQuote(this.content, startQuote + 1);
            if (endQuote == -1) {
                return null;
            }
            return this.unescapeJson(this.content.substring(startQuote + 1, endQuote));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Usage extractUsage() {
        if (!this.isSuccess() || this.content == null) {
            return null;
        }
        try {
            int usageIndex = this.content.indexOf("\"usage\"");
            if (usageIndex == -1) {
                return null;
            }
            int promptTokensIndex = this.content.indexOf("\"prompt_tokens\"", usageIndex);
            if (promptTokensIndex == -1) {
                return null;
            }
            int promptTokens = Integer.parseInt(this.extractJsonValue(this.content, promptTokensIndex));
            int completionTokensIndex = this.content.indexOf("\"completion_tokens\"", usageIndex);
            if (completionTokensIndex == -1) {
                return null;
            }
            int completionTokens = Integer.parseInt(this.extractJsonValue(this.content, completionTokensIndex));
            int totalTokensIndex = this.content.indexOf("\"total_tokens\"", usageIndex);
            if (totalTokensIndex == -1) {
                return null;
            }
            int totalTokens = Integer.parseInt(this.extractJsonValue(this.content, totalTokensIndex));
            return new Usage(promptTokens, completionTokens, totalTokens);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String extractJsonValue(String json, int index) {
        int endIndex;
        int startIndex;
        int colonIndex = json.indexOf(":", index);
        for (startIndex = colonIndex + 1; startIndex < json.length() && Character.isWhitespace(json.charAt(startIndex)); ++startIndex) {
        }
        for (endIndex = startIndex; endIndex < json.length() && Character.isDigit(json.charAt(endIndex)); ++endIndex) {
        }
        return json.substring(startIndex, endIndex);
    }

    private int findClosingQuote(String json, int startIndex) {
        boolean escaped = false;
        for (int i = startIndex; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != '\"') continue;
            return i;
        }
        return -1;
    }

    private String unescapeJson(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escaped) {
                switch (c) {
                    case '\"': {
                        result.append('\"');
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        break;
                    }
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'u': {
                        if (i + 4 < input.length()) {
                            String hex = input.substring(i + 1, i + 5);
                            try {
                                result.append((char)Integer.parseInt(hex, 16));
                                i += 4;
                            }
                            catch (NumberFormatException e) {
                                result.append(c);
                            }
                            break;
                        }
                        result.append(c);
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

