/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui;

import com.cedarxuesong.serverlocalizer.utils.ai.ModConfig;
import com.cedarxuesong.serverlocalizer.utils.gui.GuiUtils;
import com.cedarxuesong.serverlocalizer.utils.gui.ModernButton;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.BasePanel;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.ChatTranslationPanel;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.DeveloperOptionsPanel;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.ItemTranslationPanel;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.ProjectInfoPanel;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ConfigGui
extends GuiScreen {
    private static final String TAG = "ConfigGui";
    public static final int COLOR_BACKGROUND = -14671323;
    public static final int COLOR_PANEL_BACKGROUND = -13684426;
    public static final int COLOR_TEXT_WHITE = -1;
    public static final int COLOR_TEXT_HEADER = -1;
    public static final int COLOR_TEXT_LABEL = -7433577;
    public static final int COLOR_TEXT_HIGHLIGHT = -415707;
    public static final int COLOR_SCROLLBAR_BG = 0x50000000;
    public static final int COLOR_SCROLLBAR_HANDLE = -2130706433;
    private float scrollOffset = 0.0f;
    private float targetScrollOffset = 0.0f;
    private float maxScrollOffset = 0.0f;
    private boolean isDragging = false;
    private int lastMouseY = 0;
    private long lastFrameTime = 0L;
    private float[] categoryIndicatorWidths = new float[4];
    private float[] targetCategoryIndicatorWidths = new float[4];
    private ModernButton projectInfoButton;
    private ModernButton itemTranslationButton;
    private ModernButton chatTranslationButton;
    private ModernButton developerOptionsButton;
    private GuiTextField itemBaseUrlField;
    private GuiTextField itemApiKeyField;
    private GuiTextField itemModelField;
    private GuiTextField itemTemperatureField;
    private GuiTextField itemSystemPromptField;
    private GuiTextField chatBaseUrlField;
    private GuiTextField chatApiKeyField;
    private GuiTextField chatModelField;
    private GuiTextField chatTemperatureField;
    private GuiTextField chatSystemPromptField;
    private ModernButton saveButton;
    private ModernButton cancelButton;
    private ModernButton resetButton;
    private GuiButton itemTranslationToggle;
    private GuiButton itemNameToggle;
    private GuiButton itemLoreToggle;
    private GuiButton chatTranslationToggle;
    private final ModConfig modConfig;
    private int selectedCategory = 0;
    private final List<BasePanel> panels = new ArrayList<BasePanel>();
    private BasePanel currentPanel;
    private final GuiScreen parentScreen;

    public ConfigGui(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        this.modConfig = ModConfig.getInstance();
        this.panels.add(new ProjectInfoPanel(this));
        this.panels.add(new ItemTranslationPanel(this));
        this.panels.add(new ChatTranslationPanel(this));
        this.panels.add(new DeveloperOptionsPanel(this));
    }

    public ConfigGui() {
        this(null);
    }

    public void func_73866_w_() {
        mylog.log(TAG, "ConfigGui \u5f00\u59cb\u521d\u59cb\u5316 (initGui)...");
        super.func_73866_w_();
        this.lastFrameTime = System.currentTimeMillis();
        this.field_146292_n.clear();
        int leftPanelWidth = 100;
        int rightPanelX = leftPanelWidth + 20;
        int rightPanelWidth = this.field_146294_l - rightPanelX - 15;
        for (BasePanel panel : this.panels) {
            panel.initGui(rightPanelWidth);
        }
        int categoryButtonWidth = 90;
        int indicatorTargetWidth = (int)((float)categoryButtonWidth * 0.6f);
        for (int i = 0; i < 4; ++i) {
            this.targetCategoryIndicatorWidths[i] = i == this.selectedCategory ? (float)indicatorTargetWidth : 0.0f;
            this.categoryIndicatorWidths[i] = this.targetCategoryIndicatorWidths[i];
        }
        int categoryButtonX = 10;
        int categoryButtonHeight = 20;
        int categoryStartY = 40;
        this.projectInfoButton = new ModernButton(300, categoryButtonX, categoryStartY, categoryButtonWidth, categoryButtonHeight, "");
        this.itemTranslationButton = new ModernButton(301, categoryButtonX, categoryStartY + 25, categoryButtonWidth, categoryButtonHeight, "");
        this.chatTranslationButton = new ModernButton(302, categoryButtonX, categoryStartY + 50, categoryButtonWidth, categoryButtonHeight, "");
        this.developerOptionsButton = new ModernButton(303, categoryButtonX, categoryStartY + 75, categoryButtonWidth, categoryButtonHeight, "");
        this.field_146292_n.add(this.projectInfoButton);
        this.field_146292_n.add(this.itemTranslationButton);
        this.field_146292_n.add(this.chatTranslationButton);
        this.field_146292_n.add(this.developerOptionsButton);
        int bottomButtonWidth = 60;
        int bottomButtonHeight = 20;
        int bottomButtonY = this.field_146295_m - 30;
        int bottomButtonSpacing = 5;
        this.resetButton = new ModernButton(102, 10, bottomButtonY, bottomButtonWidth, bottomButtonHeight, "\u91cd\u7f6e", -5206966, -7574214);
        this.saveButton = new ModernButton(100, 10 + bottomButtonWidth + bottomButtonSpacing, bottomButtonY, bottomButtonWidth, bottomButtonHeight, "\u4fdd\u5b58", -11170188, -12358054);
        this.cancelButton = new ModernButton(101, 10 + (bottomButtonWidth + bottomButtonSpacing) * 2, bottomButtonY, bottomButtonWidth, bottomButtonHeight, "\u53d6\u6d88", -5023399, -7584443);
        this.field_146292_n.add(this.saveButton);
        this.field_146292_n.add(this.cancelButton);
        this.field_146292_n.add(this.resetButton);
        this.setCurrentPanel(this.selectedCategory);
        this.updateCategoryButtonVisuals();
    }

    private void setCurrentPanel(int categoryIndex) {
        this.selectedCategory = categoryIndex;
        this.currentPanel = this.panels.get(categoryIndex);
        this.calculateMaxScrollOffset();
    }

    private void calculateMaxScrollOffset() {
        if (this.currentPanel == null) {
            return;
        }
        int contentHeight = this.currentPanel.getContentHeight();
        int visibleHeight = this.field_146295_m - 80;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    private void updateAnimations() {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.lastFrameTime;
        this.lastFrameTime = currentTime;
        if (deltaTime > 50L) {
            deltaTime = 50L;
        }
        double k = 0.02;
        float amountToMove = (float)(1.0 - Math.exp(-k * (double)deltaTime));
        this.scrollOffset = Math.abs(this.targetScrollOffset - this.scrollOffset) > 0.1f ? (this.scrollOffset += (this.targetScrollOffset - this.scrollOffset) * amountToMove) : this.targetScrollOffset;
        for (int i = 0; i < 4; ++i) {
            if (Math.abs(this.targetCategoryIndicatorWidths[i] - this.categoryIndicatorWidths[i]) > 0.01f) {
                int n = i;
                this.categoryIndicatorWidths[n] = this.categoryIndicatorWidths[n] + (this.targetCategoryIndicatorWidths[i] - this.categoryIndicatorWidths[i]) * amountToMove;
                continue;
            }
            this.categoryIndicatorWidths[i] = this.targetCategoryIndicatorWidths[i];
        }
        this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, this.maxScrollOffset));
        this.targetScrollOffset = Math.max(0.0f, Math.min(this.targetScrollOffset, this.maxScrollOffset));
    }

    public void func_146274_d() throws IOException {
        int dWheel;
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int rightPanelX = 115;
        if (mouseX >= rightPanelX && mouseX < this.field_146294_l - 10 && (dWheel = Mouse.getEventDWheel()) != 0) {
            this.targetScrollOffset -= dWheel > 0 ? 20.0f : -20.0f;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ConfigGui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-14671323);
        this.updateAnimations();
        this.func_73732_a(this.field_146289_q, "ServerLocalizer \u914d\u7f6e", this.field_146294_l / 2, 15, -1);
        int leftPanelWidth = 100;
        int panelTopMargin = 35;
        int panelBottomMargin = 40;
        GuiUtils.drawRoundedRect(5.0f, panelTopMargin, leftPanelWidth, this.field_146295_m - panelTopMargin - panelBottomMargin, 8.0f, -13684426);
        ModernButton[] categoryButtons = new ModernButton[]{this.projectInfoButton, this.itemTranslationButton, this.chatTranslationButton, this.developerOptionsButton};
        int indicatorHeight = 2;
        int indicatorColor = -10983950;
        for (int i = 0; i < categoryButtons.length; ++i) {
            ModernButton button = categoryButtons[i];
            float currentWidth = this.categoryIndicatorWidths[i];
            if (!(currentWidth > 0.5f)) continue;
            float x = (float)button.field_146128_h + (float)button.field_146120_f / 2.0f - currentWidth / 2.0f;
            float y = button.field_146129_i + button.field_146121_g + 2;
            GuiUtils.drawRoundedRect(x, y, currentWidth, indicatorHeight, 1.0f, indicatorColor);
        }
        int rightPanelX = leftPanelWidth + 15;
        GuiUtils.drawRoundedRect(rightPanelX, panelTopMargin, this.field_146294_l - rightPanelX - 10, this.field_146295_m - panelTopMargin - panelBottomMargin, 8.0f, -13684426);
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3089);
        int scale = this.field_146297_k.field_71474_y.field_74335_Z == 0 ? 4 : this.field_146297_k.field_71474_y.field_74335_Z;
        int scissorX = rightPanelX - 5;
        int scissorY = this.field_146295_m - (this.field_146295_m - panelBottomMargin);
        int scissorWidth = this.field_146294_l - 10 - scissorX;
        int scissorHeight = this.field_146295_m - panelTopMargin - panelBottomMargin;
        GL11.glScissor((int)(scissorX * this.field_146297_k.field_71443_c / this.field_146294_l), (int)(scissorY * this.field_146297_k.field_71440_d / this.field_146295_m), (int)(scissorWidth * this.field_146297_k.field_71443_c / this.field_146294_l), (int)(scissorHeight * this.field_146297_k.field_71440_d / this.field_146295_m));
        GlStateManager.func_179109_b((float)0.0f, (float)(-this.scrollOffset), (float)0.0f);
        int localMouseY = mouseY + (int)this.scrollOffset;
        if (this.currentPanel != null) {
            this.currentPanel.drawPanel(mouseX, localMouseY, partialTicks, rightPanelX, panelTopMargin);
            for (GuiButton button : this.currentPanel.buttons) {
                button.func_146112_a(this.field_146297_k, mouseX, localMouseY);
            }
            for (GuiTextField textField : this.currentPanel.textFields) {
                textField.func_146194_f();
            }
        }
        GlStateManager.func_179121_F();
        GL11.glDisable((int)3089);
        if (this.maxScrollOffset > 0.0f) {
            this.drawScrollbar(rightPanelX, panelTopMargin, this.field_146294_l - 10, this.field_146295_m - panelBottomMargin);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawScrollbar(int panelLeft, int panelTop, int panelRight, int panelBottom) {
        if (this.currentPanel == null || this.maxScrollOffset <= 0.0f) {
            return;
        }
        int scrollbarWidth = 6;
        int padding = 4;
        int trackX = panelRight - scrollbarWidth - padding;
        int trackY = panelTop + padding;
        int trackHeight = panelBottom - panelTop - padding * 2;
        GuiUtils.drawRoundedRect(trackX, trackY, scrollbarWidth, trackHeight, 3.0f, 0x50000000);
        float visibleRatio = (float)(panelBottom - panelTop) / (float)this.currentPanel.getContentHeight();
        int thumbHeight = Math.max(20, (int)((float)trackHeight * visibleRatio));
        thumbHeight = Math.min(trackHeight, thumbHeight);
        float scrollRatio = this.scrollOffset / this.maxScrollOffset;
        int thumbY = trackY + (int)((float)(trackHeight - thumbHeight) * scrollRatio);
        GuiUtils.drawRoundedRect(trackX, thumbY, scrollbarWidth, thumbHeight, 3.0f, -2130706433);
    }

    private void drawTooltips(int mouseX, int mouseY) {
        if (this.saveButton.func_146115_a()) {
            this.func_146283_a(Arrays.asList("\u00a7e\u4fdd\u5b58", "\u4fdd\u5b58\u6240\u6709\u66f4\u6539\u5e76\u5173\u95ed\u754c\u9762\u3002"), mouseX, mouseY);
        }
        if (this.cancelButton.func_146115_a()) {
            this.func_146283_a(Arrays.asList("\u00a7e\u53d6\u6d88", "\u653e\u5f03\u6240\u6709\u672a\u4fdd\u5b58\u7684\u66f4\u6539\u5e76\u5173\u95ed\u754c\u9762\u3002"), mouseX, mouseY);
        }
        if (this.resetButton.func_146115_a()) {
            this.func_146283_a(Arrays.asList("\u00a7e\u91cd\u7f6e", "\u5c06\u754c\u9762\u4e2d\u7684\u6240\u6709\u8bbe\u7f6e\u6062\u590d\u4e3a", "\u4e0a\u6b21\u4fdd\u5b58\u65f6\u7684\u72b6\u6001\u3002"), mouseX, mouseY);
        }
        if (this.projectInfoButton.func_146115_a()) {
            this.func_146283_a(Arrays.asList("\u00a7e\u9879\u76ee\u7b80\u4ecb", "\u67e5\u770b\u6a21\u7ec4\u7684\u57fa\u672c\u4fe1\u606f\u3001\u529f\u80fd\u4ecb\u7ecd\u548c\u4f5c\u8005\u3002"), mouseX, mouseY);
        }
        if (this.itemTranslationButton.func_146115_a()) {
            this.func_146283_a(Arrays.asList("\u00a7e\u7269\u54c1\u7ffb\u8bd1\u8bbe\u7f6e", "\u914d\u7f6e\u4e0e\u7269\u54c1\u540d\u79f0\u548c\u63cf\u8ff0\u7ffb\u8bd1\u76f8\u5173\u7684\u6240\u6709\u9009\u9879\u3002"), mouseX, mouseY);
        }
        if (this.chatTranslationButton.func_146115_a()) {
            this.func_146283_a(Arrays.asList("\u00a7e\u804a\u5929\u7ffb\u8bd1\u8bbe\u7f6e", "\u914d\u7f6e\u4e0e\u804a\u5929\u5185\u5bb9\u7ffb\u8bd1\u76f8\u5173\u7684\u6240\u6709\u9009\u9879\u3002"), mouseX, mouseY);
        }
        if (this.developerOptionsButton.func_146115_a()) {
            this.func_146283_a(Arrays.asList("\u00a7e\u5f00\u53d1\u8005\u9009\u9879", "\u7528\u4e8e\u914d\u7f6e\u6a21\u7ec4\u7684\u8c03\u8bd5\u548c\u5f00\u53d1\u529f\u80fd\u3002"), mouseX, mouseY);
        }
        int rightPanelX = 115;
        int panelTopMargin = 35;
        int panelBottomMargin = 40;
        if (mouseX >= rightPanelX - 5 && mouseX < this.field_146294_l - 10 && mouseY >= panelTopMargin && mouseY < this.field_146295_m - panelBottomMargin && this.currentPanel != null) {
            int localMouseY = mouseY + (int)this.scrollOffset;
            this.currentPanel.addTooltips(mouseX, mouseY, localMouseY);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
            return;
        }
        if (this.currentPanel != null) {
            this.currentPanel.keyTyped(typedChar, keyCode);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k >= 300 && button.field_146127_k <= 303) {
            int newCategory = button.field_146127_k - 300;
            if (this.selectedCategory != newCategory) {
                this.setCurrentPanel(newCategory);
                this.scrollOffset = 0.0f;
                this.targetScrollOffset = 0.0f;
                int indicatorTargetWidth = (int)((float)this.projectInfoButton.field_146120_f * 0.6f);
                for (int i = 0; i < 4; ++i) {
                    this.targetCategoryIndicatorWidths[i] = i == this.selectedCategory ? (float)indicatorTargetWidth : 0.0f;
                }
                this.updateCategoryButtonVisuals();
            }
            return;
        }
        switch (button.field_146127_k) {
            case 100: {
                this.saveConfig();
                break;
            }
            case 101: {
                this.field_146297_k.func_147108_a(this.parentScreen);
                break;
            }
            case 102: {
                this.modConfig.resetToDefaults();
                this.field_146297_k.func_147108_a((GuiScreen)new ConfigGui(this.parentScreen));
            }
        }
        if (this.currentPanel != null) {
            this.currentPanel.actionPerformed(button);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int rightPanelX = 115;
        int panelTopMargin = 35;
        int panelBottomMargin = 40;
        if (mouseX >= rightPanelX - 5 && mouseX < this.field_146294_l - 10 && mouseY >= panelTopMargin && mouseY < this.field_146295_m - panelBottomMargin && this.currentPanel != null) {
            int localMouseY = mouseY + (int)this.scrollOffset;
            this.currentPanel.mouseClicked(mouseX, localMouseY, mouseButton);
            if (mouseButton == 0) {
                for (GuiButton button : this.currentPanel.buttons) {
                    if (!button.func_146116_c(this.field_146297_k, mouseX, localMouseY)) continue;
                    this.func_146284_a(button);
                    return;
                }
            }
        }
    }

    private void saveConfig() {
        try {
            for (BasePanel panel : this.panels) {
                panel.saveConfig();
            }
            if (this.modConfig.saveConfig()) {
                mylog.log(TAG, "\u914d\u7f6e\u4fdd\u5b58\u6210\u529f");
                this.modConfig.initialize();
                this.field_146297_k.func_147108_a(this.parentScreen);
            } else {
                mylog.error(TAG, "\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25");
            }
        }
        catch (Exception e) {
            mylog.error(TAG, "\u4fdd\u5b58\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    private void resetConfig() {
        for (BasePanel panel : this.panels) {
            panel.resetConfig();
        }
        mylog.log(TAG, "\u914d\u7f6e\u5df2\u91cd\u7f6e");
    }

    private void updateCategoryButtonVisuals() {
        this.projectInfoButton.field_146126_j = "\u9879\u76ee\u7b80\u4ecb";
        this.itemTranslationButton.field_146126_j = "\u7269\u54c1\u7ffb\u8bd1";
        this.chatTranslationButton.field_146126_j = "\u804a\u5929\u7ffb\u8bd1";
        this.developerOptionsButton.field_146126_j = "\u5f00\u53d1\u8005\u9009\u9879";
        this.projectInfoButton.packedFGColour = this.selectedCategory == 0 ? -415707 : -1;
        this.itemTranslationButton.packedFGColour = this.selectedCategory == 1 ? -415707 : -1;
        this.chatTranslationButton.packedFGColour = this.selectedCategory == 2 ? -415707 : -1;
        this.developerOptionsButton.packedFGColour = this.selectedCategory == 3 ? -415707 : -1;
        this.projectInfoButton.setColors(0, 0x30FFFFFF);
        this.itemTranslationButton.setColors(0, 0x30FFFFFF);
        this.chatTranslationButton.setColors(0, 0x30FFFFFF);
        this.developerOptionsButton.setColors(0, 0x30FFFFFF);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void drawPublicHoveringText(List<String> textLines, int x, int y) {
        super.func_146283_a(textLines, x, y);
    }

    public void func_146281_b() {
        mylog.log(TAG, "ConfigGui \u6b63\u5728\u5173\u95ed (onGuiClosed)...");
        super.func_146281_b();
    }
}

