/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui.panel;

import com.cedarxuesong.serverlocalizer.utils.gui.ModernButton;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.BasePanel;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;

public class ChatTranslationPanel
extends BasePanel {
    private static final String TAG = "ChatTranslationPanel";
    private static final String API_NAME = "ChatTranslationApi";
    private ModernButton chatTranslationToggle;
    private ModernButton streamToggle;
    private GuiTextField chatBaseUrlField;
    private GuiTextField chatApiKeyField;
    private GuiTextField chatModelField;
    private GuiTextField chatTemperatureField;
    private GuiTextField chatSystemPromptField;

    public ChatTranslationPanel(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initGui(int panelWidth) {
        this.buttons.clear();
        this.textFields.clear();
        int padding = 15;
        int contentWidth = panelWidth - padding * 2;
        int labelWidth = 70;
        int fieldWidth = contentWidth - labelWidth;
        this.chatTranslationToggle = new ModernButton(203, 0, 0, 90, 20, "");
        this.streamToggle = new ModernButton(204, 0, 0, 90, 20, "");
        this.chatBaseUrlField = new GuiTextField(11, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatBaseUrlField.func_146203_f(Short.MAX_VALUE);
        this.chatApiKeyField = new GuiTextField(5, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatApiKeyField.func_146203_f(Short.MAX_VALUE);
        this.chatModelField = new GuiTextField(6, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatModelField.func_146203_f(Short.MAX_VALUE);
        this.chatTemperatureField = new GuiTextField(7, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatTemperatureField.func_146203_f(Short.MAX_VALUE);
        this.chatSystemPromptField = new GuiTextField(9, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.chatSystemPromptField.func_146203_f(Short.MAX_VALUE);
        this.buttons.add(this.chatTranslationToggle);
        this.buttons.add(this.streamToggle);
        this.textFields.add(this.chatBaseUrlField);
        this.textFields.add(this.chatApiKeyField);
        this.textFields.add(this.chatModelField);
        this.textFields.add(this.chatTemperatureField);
        this.textFields.add(this.chatSystemPromptField);
        this.resetConfig();
    }

    @Override
    public void drawPanel(int mouseX, int localMouseY, float partialTicks, int panelX, int panelY) {
        int padding = 15;
        int contentX = panelX + padding;
        int y = panelY + padding;
        int labelWidth = 70;
        this.chatTranslationToggle.field_146128_h = contentX;
        this.chatTranslationToggle.field_146129_i = y;
        this.drawString("Base URL:", contentX, (y += 35) + 5);
        this.chatBaseUrlField.field_146209_f = contentX + labelWidth;
        this.chatBaseUrlField.field_146210_g = y;
        this.chatBaseUrlField.func_146194_f();
        this.drawString("API Key:", contentX, (y += 25) + 5);
        this.chatApiKeyField.field_146209_f = contentX + labelWidth;
        this.chatApiKeyField.field_146210_g = y;
        this.chatApiKeyField.func_146194_f();
        this.drawString("\u6a21\u578b:", contentX, (y += 25) + 5);
        this.chatModelField.field_146209_f = contentX + labelWidth;
        this.chatModelField.field_146210_g = y;
        this.chatModelField.func_146194_f();
        this.drawString("\u6e29\u5ea6:", contentX, (y += 25) + 5);
        this.chatTemperatureField.field_146209_f = contentX + labelWidth;
        this.chatTemperatureField.field_146210_g = y;
        this.chatTemperatureField.func_146194_f();
        this.drawString("\u7cfb\u7edf\u63d0\u793a\u8bcd:", contentX, (y += 25) + 5);
        this.chatSystemPromptField.field_146209_f = contentX + labelWidth;
        this.chatSystemPromptField.field_146210_g = y;
        this.chatSystemPromptField.func_146194_f();
        this.streamToggle.field_146128_h = contentX;
        this.streamToggle.field_146129_i = y += 35;
    }

    @Override
    public void addTooltips(int mouseX, int mouseY, int localMouseY) {
        if (this.isMouseOver(this.chatTranslationToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u804a\u5929\u7ffb\u8bd1\u603b\u5f00\u5173", "\u542f\u7528\u6216\u7981\u7528\u6240\u6709\u804a\u5929\u5185\u5bb9\u7684\u7ffb\u8bd1\u529f\u80fd\u3002"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.streamToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u6d41\u5f0f\u54cd\u5e94", "\u542f\u7528\u540e\uff0c\u7ffb\u8bd1\u7ed3\u679c\u5c06\u9010\u5b57\u663e\u793a\uff0c", "\u65e0\u9700\u7b49\u5f85\u5b8c\u6574\u54cd\u5e94\uff0c\u5b9e\u65f6\u67e5\u770b\u3002"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatBaseUrlField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7eBase URL", "\u4f60\u7684API\u670d\u52a1\u5668\u5730\u5740\u3002", "\u4f8b\u5982: \u00a77https://api.openai.com/v1"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatApiKeyField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7eAPI Key", "\u4f60\u7684API\u5bc6\u94a5\u3002", "\u4f8b\u5982: \u00a77sk-xxxxxxxx"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatModelField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u6a21\u578b", "\u6240\u4f7f\u7528\u7684AI\u6a21\u578b\u3002", "\u4f8b\u5982: \u00a77gpt-4o, deepseek-v3"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatTemperatureField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u6e29\u5ea6 (0.0 - 2.0)", "\u63a7\u5236\u751f\u6210\u6587\u672c\u7684\u968f\u673a\u6027\u3002", "\u00a77\u8f83\u4f4e\u503c (\u59820.2) -> \u66f4\u7a33\u5b9a\u3001\u786e\u5b9a", "\u00a77\u8f83\u9ad8\u503c (\u59820.8) -> \u66f4\u5177\u521b\u9020\u6027"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.chatSystemPromptField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u7cfb\u7edf\u63d0\u793a\u8bcd (\u4e0d\u5efa\u8bae\u4fee\u6539)", "\u7ed9AI\u8bbe\u5b9a\u7684\u521d\u59cb\u6307\u4ee4\u6216\u89d2\u8272\uff0c", "\u7528\u4e8e\u6307\u5bfc\u5176\u7ffb\u8bd1\u884c\u4e3a\u3002"), mouseX, mouseY);
        }
    }

    @Override
    public int getContentHeight() {
        return 300;
    }

    @Override
    public void saveConfig() {
        this.modConfig.setBaseUrl(API_NAME, this.chatBaseUrlField.func_146179_b());
        this.modConfig.setApiKey(API_NAME, this.chatApiKeyField.func_146179_b());
        this.modConfig.setModel(API_NAME, this.chatModelField.func_146179_b());
        try {
            this.modConfig.setTemperature(API_NAME, Double.parseDouble(this.chatTemperatureField.func_146179_b()));
        }
        catch (NumberFormatException e) {
            mylog.error(TAG, "\u65e0\u6548\u7684\u804a\u5929\u7ffb\u8bd1\u6e29\u5ea6\u503c: " + this.chatTemperatureField.func_146179_b());
        }
        this.modConfig.setSystemPrompt(API_NAME, this.chatSystemPromptField.func_146179_b());
    }

    @Override
    public void resetConfig() {
        this.chatBaseUrlField.func_146180_a(this.modConfig.getBaseUrl(API_NAME));
        this.chatApiKeyField.func_146180_a(this.modConfig.getApiKey(API_NAME));
        this.chatModelField.func_146180_a(this.modConfig.getModel(API_NAME));
        this.chatTemperatureField.func_146180_a(String.valueOf(this.modConfig.getTemperature(API_NAME)));
        this.chatSystemPromptField.func_146180_a(this.modConfig.getSystemPrompt(API_NAME));
        this.updateButtonLabels();
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 203: {
                boolean chatEnabled = !this.modConfig.isChatTranslationEnabled();
                this.modConfig.setChatTranslationEnabled(chatEnabled);
                break;
            }
            case 204: {
                boolean streamEnabled = !this.modConfig.isChatStreamEnabled();
                this.modConfig.setChatStreamEnabled(streamEnabled);
            }
        }
        this.updateButtonLabels();
    }

    private void updateButtonLabels() {
        int IDLE_ON = -10983950;
        int HOVER_ON = -12102972;
        int IDLE_OFF = -13223617;
        int HOVER_OFF = -11907757;
        int TEXT_COLOR = -1;
        boolean chatEnabled = this.modConfig.isChatTranslationEnabled();
        this.chatTranslationToggle.field_146126_j = "\u804a\u5929\u7ffb\u8bd1: " + (chatEnabled ? "\u00a7a\u5f00" : "\u00a7c\u5173");
        this.chatTranslationToggle.setColors(chatEnabled ? -10983950 : -13223617, chatEnabled ? -12102972 : -11907757);
        this.chatTranslationToggle.packedFGColour = -1;
        boolean streamEnabled = this.modConfig.isChatStreamEnabled();
        this.streamToggle.field_146126_j = "\u6d41\u5f0f\u54cd\u5e94: " + (streamEnabled ? "\u00a7a\u5f00" : "\u00a7c\u5173");
        this.streamToggle.setColors(streamEnabled ? -10983950 : -13223617, streamEnabled ? -12102972 : -11907757);
        this.streamToggle.packedFGColour = -1;
        this.streamToggle.field_146124_l = chatEnabled;
    }
}

