/*
 * Decompiled with CFR 0.152.
 */
package com.cedarxuesong.serverlocalizer.utils.gui.panel;

import com.cedarxuesong.serverlocalizer.utils.gui.ModernButton;
import com.cedarxuesong.serverlocalizer.utils.gui.panel.BasePanel;
import com.cedarxuesong.serverlocalizer.utils.mylog.mylog;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;

public class ItemTranslationPanel
extends BasePanel {
    private static final String TAG = "ItemTranslationPanel";
    private static final String API_NAME = "ItemTranslationApi";
    private ModernButton itemTranslationToggle;
    private GuiTextField itemBaseUrlField;
    private GuiTextField itemApiKeyField;
    private GuiTextField itemModelField;
    private GuiTextField itemTemperatureField;
    private GuiTextField itemSystemPromptField;
    private ModernButton itemNameToggle;
    private ModernButton itemLoreToggle;

    public ItemTranslationPanel(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void initGui(int panelWidth) {
        this.buttons.clear();
        this.textFields.clear();
        int padding = 15;
        int contentWidth = panelWidth - padding * 2;
        int labelWidth = 70;
        int fieldWidth = contentWidth - labelWidth;
        this.itemTranslationToggle = new ModernButton(200, 0, 0, 90, 20, "");
        this.itemBaseUrlField = new GuiTextField(10, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemBaseUrlField.func_146203_f(Short.MAX_VALUE);
        this.itemApiKeyField = new GuiTextField(1, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemApiKeyField.func_146203_f(Short.MAX_VALUE);
        this.itemModelField = new GuiTextField(2, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemModelField.func_146203_f(Short.MAX_VALUE);
        this.itemTemperatureField = new GuiTextField(3, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemTemperatureField.func_146203_f(Short.MAX_VALUE);
        this.itemSystemPromptField = new GuiTextField(8, this.fontRendererObj, 0, 0, fieldWidth, 20);
        this.itemSystemPromptField.func_146203_f(Short.MAX_VALUE);
        this.itemNameToggle = new ModernButton(201, 0, 0, 90, 20, "");
        this.itemLoreToggle = new ModernButton(202, 0, 0, 90, 20, "");
        this.buttons.add(this.itemTranslationToggle);
        this.buttons.add(this.itemNameToggle);
        this.buttons.add(this.itemLoreToggle);
        this.textFields.add(this.itemBaseUrlField);
        this.textFields.add(this.itemApiKeyField);
        this.textFields.add(this.itemModelField);
        this.textFields.add(this.itemTemperatureField);
        this.textFields.add(this.itemSystemPromptField);
        this.resetConfig();
    }

    @Override
    public void drawPanel(int mouseX, int localMouseY, float partialTicks, int panelX, int panelY) {
        int padding = 15;
        int contentX = panelX + padding;
        int y = panelY + padding;
        int labelWidth = 70;
        int toggleWidth = 90;
        this.itemTranslationToggle.field_146128_h = contentX;
        this.itemTranslationToggle.field_146129_i = y;
        this.drawString("Base URL:", contentX, (y += 35) + 5);
        this.itemBaseUrlField.field_146209_f = contentX + labelWidth;
        this.itemBaseUrlField.field_146210_g = y;
        this.itemBaseUrlField.func_146194_f();
        this.drawString("API Key:", contentX, (y += 25) + 5);
        this.itemApiKeyField.field_146209_f = contentX + labelWidth;
        this.itemApiKeyField.field_146210_g = y;
        this.itemApiKeyField.func_146194_f();
        this.drawString("\u6a21\u578b:", contentX, (y += 25) + 5);
        this.itemModelField.field_146209_f = contentX + labelWidth;
        this.itemModelField.field_146210_g = y;
        this.itemModelField.func_146194_f();
        this.drawString("\u6e29\u5ea6:", contentX, (y += 25) + 5);
        this.itemTemperatureField.field_146209_f = contentX + labelWidth;
        this.itemTemperatureField.field_146210_g = y;
        this.itemTemperatureField.func_146194_f();
        this.drawString("\u7cfb\u7edf\u63d0\u793a\u8bcd:", contentX, (y += 25) + 5);
        this.itemSystemPromptField.field_146209_f = contentX + labelWidth;
        this.itemSystemPromptField.field_146210_g = y;
        this.itemSystemPromptField.func_146194_f();
        this.itemNameToggle.field_146128_h = contentX;
        this.itemNameToggle.field_146129_i = y += 35;
        this.itemLoreToggle.field_146128_h = contentX + toggleWidth + 10;
        this.itemLoreToggle.field_146129_i = y;
        long accumulatedTokens = this.modConfig.getAccumulatedTokens(API_NAME);
        String tokenUsageText = "\u7d2f\u8ba1\u4f7f\u7528Tokens: " + accumulatedTokens;
        this.drawString(tokenUsageText, contentX, y += 25);
    }

    @Override
    public void addTooltips(int mouseX, int mouseY, int localMouseY) {
        if (this.isMouseOver(this.itemTranslationToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u7269\u54c1\u7ffb\u8bd1\u603b\u5f00\u5173", "\u542f\u7528\u6216\u7981\u7528\u6240\u6709\u7269\u54c1\uff08\u540d\u79f0\u548c\u63cf\u8ff0\uff09\u7684\u7ffb\u8bd1\u529f\u80fd\u3002"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemBaseUrlField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7eBase URL", "\u4f60\u7684API\u670d\u52a1\u5668\u5730\u5740\u3002", "\u4f8b\u5982: \u00a77https://api.openai.com/v1"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemApiKeyField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7eAPI Key", "\u4f60\u7684API\u5bc6\u94a5\u3002", "\u4f8b\u5982: \u00a77sk-xxxxxxxx"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemModelField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u6a21\u578b", "\u6240\u4f7f\u7528\u7684AI\u6a21\u578b\u3002", "\u4f8b\u5982: \u00a77gpt-4o, deepseek-v3"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemTemperatureField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u6e29\u5ea6 (0.0 - 2.0)", "\u63a7\u5236\u751f\u6210\u6587\u672c\u7684\u968f\u673a\u6027\u3002", "\u00a77\u8f83\u4f4e\u503c (\u59820.2) -> \u66f4\u7a33\u5b9a\u3001\u786e\u5b9a", "\u00a77\u8f83\u9ad8\u503c (\u59820.8) -> \u66f4\u5177\u521b\u9020\u6027"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemSystemPromptField, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u7cfb\u7edf\u63d0\u793a\u8bcd (\u4e0d\u5efa\u8bae\u4fee\u6539)", "\u7ed9AI\u8bbe\u5b9a\u7684\u521d\u59cb\u6307\u4ee4\u6216\u89d2\u8272\uff0c", "\u7528\u4e8e\u6307\u5bfc\u5176\u7ffb\u8bd1\u884c\u4e3a\u3002"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemNameToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u7269\u54c1\u540d\u79f0\u7ffb\u8bd1", "\u5355\u72ec\u63a7\u5236\u7269\u54c1\u540d\u79f0\u7684\u7ffb\u8bd1\u529f\u80fd\u3002"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.itemLoreToggle, mouseX, localMouseY)) {
            this.drawHoveringText(Arrays.asList("\u00a7e\u7269\u54c1\u63cf\u8ff0\u7ffb\u8bd1", "\u5355\u72ec\u63a7\u5236\u7269\u54c1Lore(\u63cf\u8ff0)\u7684\u7ffb\u8bd1\u529f\u80fd\u3002"), mouseX, mouseY);
        }
    }

    @Override
    public int getContentHeight() {
        return 340;
    }

    @Override
    public void saveConfig() {
        this.modConfig.setBaseUrl(API_NAME, this.itemBaseUrlField.func_146179_b());
        this.modConfig.setApiKey(API_NAME, this.itemApiKeyField.func_146179_b());
        this.modConfig.setModel(API_NAME, this.itemModelField.func_146179_b());
        try {
            this.modConfig.setTemperature(API_NAME, Double.parseDouble(this.itemTemperatureField.func_146179_b()));
        }
        catch (NumberFormatException e) {
            mylog.error(TAG, "\u65e0\u6548\u7684\u7269\u54c1\u7ffb\u8bd1\u6e29\u5ea6\u503c: " + this.itemTemperatureField.func_146179_b());
        }
        this.modConfig.setSystemPrompt(API_NAME, this.itemSystemPromptField.func_146179_b());
    }

    @Override
    public void resetConfig() {
        this.itemBaseUrlField.func_146180_a(this.modConfig.getBaseUrl(API_NAME));
        this.itemApiKeyField.func_146180_a(this.modConfig.getApiKey(API_NAME));
        this.itemModelField.func_146180_a(this.modConfig.getModel(API_NAME));
        this.itemTemperatureField.func_146180_a(String.valueOf(this.modConfig.getTemperature(API_NAME)));
        this.itemSystemPromptField.func_146180_a(this.modConfig.getSystemPrompt(API_NAME));
        this.updateButtonLabels();
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 200: {
                boolean itemEnabled = !this.modConfig.isItemTranslationEnabled();
                this.modConfig.setItemTranslationEnabled(itemEnabled);
                break;
            }
            case 201: {
                boolean nameEnabled = !this.modConfig.isItemNameTranslationEnabled();
                this.modConfig.setItemNameTranslationEnabled(nameEnabled);
                break;
            }
            case 202: {
                boolean loreEnabled = !this.modConfig.isItemLoreTranslationEnabled();
                this.modConfig.setItemLoreTranslationEnabled(loreEnabled);
            }
        }
        this.updateButtonLabels();
    }

    private void updateButtonLabels() {
        int IDLE_ON = -10983950;
        int HOVER_ON = -12102972;
        int IDLE_OFF = -13223617;
        int HOVER_OFF = -11907757;
        int TEXT_COLOR = -1;
        boolean itemEnabled = this.modConfig.isItemTranslationEnabled();
        this.itemTranslationToggle.field_146126_j = "\u7269\u54c1\u7ffb\u8bd1: " + (itemEnabled ? "\u00a7a\u5f00" : "\u00a7c\u5173");
        this.itemTranslationToggle.setColors(itemEnabled ? -10983950 : -13223617, itemEnabled ? -12102972 : -11907757);
        this.itemTranslationToggle.packedFGColour = -1;
        boolean nameEnabled = this.modConfig.isItemNameTranslationEnabled();
        this.itemNameToggle.field_146126_j = "\u7269\u54c1\u540d: " + (nameEnabled ? "\u00a7a\u5f00" : "\u00a7c\u5173");
        this.itemNameToggle.setColors(nameEnabled ? -10983950 : -13223617, nameEnabled ? -12102972 : -11907757);
        this.itemNameToggle.packedFGColour = -1;
        this.itemNameToggle.field_146124_l = itemEnabled;
        boolean loreEnabled = this.modConfig.isItemLoreTranslationEnabled();
        this.itemLoreToggle.field_146126_j = "\u7269\u54c1\u63cf\u8ff0: " + (loreEnabled ? "\u00a7a\u5f00" : "\u00a7c\u5173");
        this.itemLoreToggle.setColors(loreEnabled ? -10983950 : -13223617, loreEnabled ? -12102972 : -11907757);
        this.itemLoreToggle.packedFGColour = -1;
        this.itemLoreToggle.field_146124_l = itemEnabled;
    }
}

